/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import io.vertx.tracing.zipkin.ZipkinBaseTest;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.testcontainers.containers.PostgreSQLContainer;
import zipkin2.Span;

@Ignore
public class SqlClientTest
extends ZipkinBaseTest {
    private static PostgreSQLContainer<?> server;
    private static PgConnectOptions connectOptions;
    private PgPool pool;

    @BeforeClass
    public static void startDB() throws Exception {
        server = new PostgreSQLContainer("postgres:10").withDatabaseName("postgres").withUsername("postgres").withPassword("postgres");
        server.start();
        InetAddress ip = Inet4Address.getByName(server.getContainerIpAddress());
        connectOptions = new PgConnectOptions().setUser("postgres").setPassword("postgres").setDatabase("postgres").setHost(ip.getHostAddress()).setPort(server.getMappedPort(5432).intValue());
    }

    @AfterClass
    public static void stopDB() {
        server.stop();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)connectOptions, (PoolOptions)new PoolOptions());
    }

    @Test
    public void testPreparedQuery(TestContext ctx) throws Exception {
        Async listenLatch = ctx.async();
        long baseDurationInMs = 500L;
        this.vertx.createHttpServer().requestHandler(req -> this.pool.preparedQuery("SELECT $1 \"VAL\"").execute(Tuple.of((Object)"Hello World")).onComplete(ar -> this.vertx.setTimer(baseDurationInMs, __ -> {
            if (ar.succeeded()) {
                RowSet rows = (RowSet)ar.result();
                req.response().end();
            } else {
                req.response().setStatusCode(500).end();
            }
        }))).listen(8080, ctx.asyncAssertSuccess(v -> listenLatch.complete()));
        listenLatch.awaitSuccess();
        Async responseLatch = ctx.async();
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setTracingPolicy(TracingPolicy.ALWAYS));
        client.request(HttpMethod.GET, 8080, "localhost", "/", ctx.asyncAssertSuccess(req -> req.send(ctx.asyncAssertSuccess(resp -> {
            ctx.assertEquals((Object)200, (Object)resp.statusCode());
            responseLatch.complete();
        }))));
        responseLatch.awaitSuccess();
        List<Span> trace = this.assertSingleSpan(this.waitUntilTrace(3));
        Assert.assertEquals((long)3L, (long)trace.size());
        Span span1 = trace.get(0);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span1.kind());
        Assert.assertEquals((Object)"my-service-name", (Object)span1.localServiceName());
        Assert.assertEquals((Object)"get", (Object)span1.name());
        Assert.assertEquals((Object)"GET", span1.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span1.tags().get("http.path"));
        Assert.assertEquals((long)8080L, (long)span1.remoteEndpoint().portAsInt());
        Span span2 = trace.get(1);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span2.kind());
        Assert.assertEquals((Object)"get", (Object)span2.name());
        Assert.assertEquals((Object)"GET", span2.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span2.tags().get("http.path"));
        Assert.assertNotNull((Object)span2.duration());
        Assert.assertNotNull((Object)span2.timestamp());
        Assert.assertTrue((TimeUnit.MILLISECONDS.convert(span2.durationAsLong(), TimeUnit.MICROSECONDS) > baseDurationInMs ? 1 : 0) != 0);
        Span span3 = trace.get(2);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span3.kind());
        Assert.assertEquals((Object)"postgres", (Object)span3.remoteServiceName());
        Assert.assertEquals((Object)connectOptions.getHost(), (Object)span3.remoteEndpoint().ipv4());
        Assert.assertEquals((long)connectOptions.getPort(), (long)span3.remoteEndpoint().portAsInt());
        Assert.assertEquals((Object)"SELECT $1 \"VAL\"", span3.tags().get("sql.query"));
    }
}

