/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.tracing.zipkin.HttpSenderOptions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;

public class VertxSender
extends Sender {
    private static final CharSequence APPLICATION_JSON = HttpHeaders.createOptimized((String)"application/json");
    private final int messageMaxBytes = 0x500000;
    private final Vertx vertx;
    private final HttpClient client;
    private final String endpoint;

    public VertxSender(HttpSenderOptions options) {
        this.endpoint = options.getSenderEndpoint();
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setTracingOptions(new TracingOptions().setFactory(VertxTracerFactory.NOOP)));
        this.client = this.vertx.createHttpClient((HttpClientOptions)options);
    }

    public Encoding encoding() {
        return Encoding.JSON;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        int val = 2;
        int length = encodedSpans.size();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ++val;
            }
            val += encodedSpans.get(i).length;
        }
        return val;
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        int capacity = this.messageSizeInBytes(encodedSpans);
        Buffer body = Buffer.buffer((int)capacity);
        body.appendByte((byte)91);
        for (int i = 0; i < encodedSpans.size(); ++i) {
            if (i > 0) {
                body.appendByte((byte)44);
            }
            body.appendBytes(encodedSpans.get(i));
        }
        body.appendByte((byte)93);
        return new PostCall(body);
    }

    public void close() throws IOException {
        this.client.close();
        this.vertx.close();
    }

    private class PostCall
    extends Call<Void>
    implements Handler<AsyncResult<Callback<Void>>> {
        private final Promise<Callback<Void>> promise = Promise.promise();
        private final Future<Callback<Void>> fut = this.promise.future().onComplete((Handler)this);
        private final Buffer body;

        PostCall(Buffer body) {
            this.body = body;
        }

        public void handle(AsyncResult<Callback<Void>> ar) {
            if (ar.succeeded()) {
                Callback callback = (Callback)ar.result();
                RequestOptions options = new RequestOptions().setMethod(HttpMethod.POST).addHeader(HttpHeaders.CONTENT_TYPE, APPLICATION_JSON);
                if (VertxSender.this.endpoint.startsWith("http://") || VertxSender.this.endpoint.startsWith("https://")) {
                    options.setAbsoluteURI(VertxSender.this.endpoint);
                } else {
                    options.setURI(VertxSender.this.endpoint);
                }
                VertxSender.this.client.request(options).compose(req -> req.send(this.body).compose(HttpClientResponse::body)).onComplete(res -> {
                    if (res.succeeded()) {
                        callback.onSuccess(null);
                    } else {
                        callback.onError(res.cause());
                    }
                });
            }
        }

        public Void execute() throws IOException {
            final CompletableFuture fut = new CompletableFuture();
            this.enqueue(new Callback<Void>(){

                public void onSuccess(Void value) {
                    fut.complete(null);
                }

                public void onError(Throwable t) {
                    fut.completeExceptionally(t);
                }
            });
            try {
                return (Void)fut.get(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
            catch (TimeoutException e) {
                throw new IOException(e);
            }
        }

        public void enqueue(Callback<Void> callback) {
            if (!this.promise.tryComplete(callback)) {
                throw new IllegalStateException();
            }
        }

        public void cancel() {
        }

        public boolean isCanceled() {
            return false;
        }

        public Call<Void> clone() {
            return new PostCall(this.body);
        }
    }
}

