/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.propagation.TraceContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.tracing.zipkin.ZipkinBaseTest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import zipkin2.Span;

public class ZipkinGenericPropagationTest
extends ZipkinBaseTest {
    @Test
    public void serverToClient(TestContext ctx) throws Exception {
        Async listenLatch = ctx.async();
        this.vertx.createHttpServer().requestHandler(req -> {
            ContextInternal current = (ContextInternal)Vertx.currentContext();
            VertxTracer tracer = current.tracer();
            TraceContext requestContext = (TraceContext)current.getLocal("vertx.tracing.zipkin.active_context");
            Object request = new Object();
            HashMap headers = new HashMap();
            Object trace = tracer.sendRequest((Context)current, SpanKind.RPC, TracingPolicy.PROPAGATE, request, "my_op", headers::put, TagExtractor.empty());
            ctx.assertEquals((Object)requestContext.traceIdString(), headers.get("X-B3-TraceId"));
            ctx.assertNotNull(headers.get("X-B3-SpanId"));
            ctx.assertEquals((Object)requestContext.spanIdString(), headers.get("X-B3-ParentSpanId"));
            current.setTimer(10L, id -> {
                Object response = new Object();
                tracer.receiveResponse((Context)current, response, trace, null, TagExtractor.empty());
                req.response().end();
            });
        }).listen(8080, ctx.asyncAssertSuccess(v -> listenLatch.complete()));
        listenLatch.awaitSuccess();
        Async responseLatch = ctx.async();
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setTracingPolicy(TracingPolicy.ALWAYS));
        client.request(HttpMethod.GET, 8080, "localhost", "/", ctx.asyncAssertSuccess(req -> req.send(ctx.asyncAssertSuccess(resp -> {
            ctx.assertEquals((Object)200, (Object)resp.statusCode());
            responseLatch.complete();
        }))));
        responseLatch.awaitSuccess();
        List<Span> trace = this.assertSingleSpan(this.waitUntilTrace(3));
        Assert.assertEquals((long)3L, (long)trace.size());
        Span span1 = trace.get(0);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span1.kind());
        Assert.assertEquals((Object)"my-service-name", (Object)span1.localServiceName());
        Assert.assertEquals((Object)"get", (Object)span1.name());
        Assert.assertEquals((Object)"GET", span1.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span1.tags().get("http.path"));
        Assert.assertEquals((long)8080L, (long)span1.remoteEndpoint().portAsInt());
        Span span2 = trace.get(1);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span2.kind());
        Assert.assertEquals((Object)"get", (Object)span2.name());
        Assert.assertEquals((Object)"GET", span2.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span2.tags().get("http.path"));
        Span span3 = trace.get(2);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span3.kind());
    }

    @Test
    public void clientToServer(TestContext ctx) throws Exception {
        VertxInternal vertx = (VertxInternal)this.vertx;
        ContextInternal current = vertx.getOrCreateContext();
        VertxTracer tracer = current.tracer();
        HashMap headers = new HashMap();
        Object clientTrace = tracer.sendRequest((Context)current, SpanKind.RPC, TracingPolicy.ALWAYS, new Object(), "foo", headers::put, TagExtractor.empty());
        EventLoopContext receiving = vertx.createEventLoopContext();
        Async responseLatch = ctx.async();
        receiving.runOnContext(arg_0 -> ZipkinGenericPropagationTest.lambda$clientToServer$5((ContextInternal)receiving, tracer, headers, responseLatch, arg_0));
        responseLatch.await(20000L);
        tracer.receiveResponse((Context)current, new Object(), clientTrace, null, TagExtractor.empty());
        List<Span> trace = this.assertSingleSpan(this.waitUntilTrace(2));
        Span span1 = trace.get(0);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span1.kind());
        Assert.assertEquals((Object)"my-service-name", (Object)span1.localServiceName());
        Assert.assertEquals((Object)"foo", (Object)span1.name());
        Span span2 = trace.get(1);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span2.kind());
        Assert.assertEquals((Object)"my-service-name", (Object)span2.localServiceName());
        Assert.assertEquals((Object)"bar", (Object)span2.name());
    }

    private static /* synthetic */ void lambda$clientToServer$5(ContextInternal receiving, VertxTracer tracer, Map headers, Async responseLatch, Void v) {
        ContextInternal duplicate = receiving.duplicate();
        Object serverTrace = tracer.receiveRequest((Context)duplicate, SpanKind.RPC, TracingPolicy.PROPAGATE, new Object(), "bar", headers.entrySet(), TagExtractor.empty());
        tracer.sendResponse((Context)duplicate, new Object(), serverTrace, null, TagExtractor.empty());
        responseLatch.complete();
    }
}

