/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.tracing.zipkin.HttpSenderOptions;
import io.vertx.tracing.zipkin.ZipkinTracingOptions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import zipkin2.Span;
import zipkin2.junit.ZipkinRule;

@RunWith(value=VertxUnitRunner.class)
public abstract class ZipkinBaseTest {
    @Rule
    public ZipkinRule zipkin = new ZipkinRule();
    protected Vertx vertx;
    protected HttpClient client;

    @Before
    public void before() {
        String url = this.zipkin.httpUrl() + "/api/v2/spans";
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setTracingOptions((TracingOptions)new ZipkinTracingOptions().setServiceName("my-service-name").setSupportsJoin(false).setSenderOptions(new HttpSenderOptions().setSenderEndpoint(url))));
        this.client = this.vertx.createHttpClient(this.getHttpClientOptions());
    }

    protected HttpClientOptions getHttpClientOptions() {
        return new HttpClientOptions().setTracingPolicy(TracingPolicy.ALWAYS);
    }

    @After
    public void after(TestContext ctx) {
        this.client.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    List<Span> waitUntilTrace(int min) throws Exception {
        return ZipkinBaseTest.waitUntilTrace(this.zipkin, min);
    }

    static List<Span> waitUntilTrace(ZipkinRule zipkin, int min) throws Exception {
        long now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now < 10000L) {
            List traces = zipkin.getTraces();
            if (traces.size() > 0 && ((List)traces.get(0)).size() >= min) {
                return (List)traces.get(0);
            }
            Thread.sleep(10L);
        }
        throw new AssertionError((Object)("Got traces " + zipkin.getTraces()));
    }

    static <T> T waitUntilTrace(Callable<Optional<T>> pred) throws Exception {
        long now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now < 10000L) {
            Optional<T> opt = pred.call();
            if (opt.isPresent()) {
                return opt.get();
            }
            Thread.sleep(10L);
        }
        throw new AssertionError();
    }

    List<Span> assertSingleSpan(List<Span> spans) {
        long result = spans.stream().map(Span::traceId).distinct().count();
        Assert.assertEquals((long)1L, (long)result);
        spans = new ArrayList<Span>(spans);
        Span top = spans.stream().filter(span -> span.id().equals(span.traceId())).findFirst().get();
        spans.remove(top);
        LinkedList<Span> sorted = this.foo(top, spans);
        sorted.addFirst(top);
        return sorted;
    }

    private LinkedList<Span> foo(Span top, List<Span> others) {
        if (others.isEmpty()) {
            return new LinkedList<Span>();
        }
        Span s = others.stream().filter(span -> span.parentId().equals(top.id())).findFirst().get();
        others.remove(s);
        LinkedList<Span> ret = this.foo(s, others);
        ret.addFirst(s);
        return ret;
    }
}

