/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.tracing.zipkin.ZipkinBaseTest;
import io.vertx.tracing.zipkin.ZipkinTracingOptions;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import zipkin2.Span;
import zipkin2.junit.ZipkinRule;

@RunWith(value=VertxUnitRunner.class)
public class VertxSenderTest {
    private Vertx vertx;

    @Before
    public void before() {
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setTracingOptions((TracingOptions)new ZipkinTracingOptions()));
    }

    @After
    public void after(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultSenderEndpoint(TestContext ctx) throws Exception {
        ZipkinRule zipkin = new ZipkinRule();
        zipkin.start(9411);
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setTracingPolicy(TracingPolicy.ALWAYS));
        try {
            Async listenLatch = ctx.async();
            this.vertx.createHttpServer().requestHandler(req -> req.response().end()).listen(8080, ctx.asyncAssertSuccess(v -> listenLatch.complete()));
            listenLatch.awaitSuccess();
            Async responseLatch = ctx.async();
            client.request(HttpMethod.GET, 8080, "localhost", "/", ctx.asyncAssertSuccess(req -> req.send(ctx.asyncAssertSuccess(resp -> responseLatch.complete()))));
            responseLatch.awaitSuccess();
            List<Span> trace = ZipkinBaseTest.waitUntilTrace(zipkin, 2);
            Assert.assertEquals((long)2L, (long)trace.size());
            responseLatch.await(10000L);
        }
        finally {
            client.close();
            zipkin.shutdown();
        }
    }
}

