/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZipkinTracer
implements VertxTracer<Span, BiConsumer<Object, Throwable>> {
    public static final String ACTIVE_SPAN = "vertx.tracing.zipkin.active_span";
    public static final String ACTIVE_CONTEXT = "vertx.tracing.zipkin.active_context";
    public static final String ACTIVE_REQUEST = "vertx.tracing.zipkin.active_request";
    static final HttpServerAdapter<HttpServerRequest, HttpServerRequest> HTTP_SERVER_ADAPTER = new HttpServerAdapter<HttpServerRequest, HttpServerRequest>(){

        public String method(HttpServerRequest request) {
            return request.method().name();
        }

        public String url(HttpServerRequest request) {
            return request.absoluteURI();
        }

        public String requestHeader(HttpServerRequest request, String name) {
            return request.headers().get(name);
        }

        public Integer statusCode(HttpServerRequest request) {
            return request.response().getStatusCode();
        }

        public String methodFromResponse(HttpServerRequest request) {
            return request.method().name();
        }

        public String route(HttpServerRequest request) {
            return "";
        }

        public boolean parseClientIpAndPort(HttpServerRequest request, Span span) {
            if (this.parseClientIpFromXForwardedFor(request, span)) {
                return true;
            }
            SocketAddress addr = request.remoteAddress();
            if (addr != null && addr.hostAddress() != null) {
                return span.remoteIpAndPort(addr.hostAddress(), addr.port());
            }
            return false;
        }
    };
    static final HttpClientAdapter<HttpRequest, HttpResponse> HTTP_CLIENT_ADAPTER = new HttpClientAdapter<HttpRequest, HttpResponse>(){

        public String method(HttpRequest request) {
            HttpMethod method = request.method();
            return method.name();
        }

        public String url(HttpRequest request) {
            return request.absoluteURI();
        }

        public String requestHeader(HttpRequest request, String name) {
            return request.headers().get(name);
        }

        public Integer statusCode(HttpResponse response) {
            return response.statusCode();
        }
    };
    private static final Propagation.Getter<HttpServerRequest, String> HTTP_SERVER_GETTER = new Propagation.Getter<HttpServerRequest, String>(){

        public String get(HttpServerRequest carrier, String key) {
            return carrier.getHeader(key);
        }
    };
    private static final Propagation.Getter<Map<String, String>, String> MAP_GETTER = new Propagation.Getter<Map<String, String>, String>(){

        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key);
        }
    };
    private final TraceContext.Extractor<HttpServerRequest> httpServerExtractor;
    private final Tracing tracing;
    private final boolean closeTracer;
    private final HttpServerHandler<HttpServerRequest, HttpServerRequest> httpServerHandler;
    private final HttpClientHandler<HttpRequest, HttpResponse> clientHandler;
    private final TraceContext.Extractor<Map<String, String>> mapExtractor;
    private static final Pattern P = Pattern.compile("^([^:]+):([0-9]+)$");

    public static Span activeSpan() {
        Context ctx = Vertx.currentContext();
        if (ctx != null) {
            return (Span)ctx.getLocal(ACTIVE_SPAN);
        }
        return null;
    }

    public static TraceContext activeContext() {
        Context ctx = Vertx.currentContext();
        if (ctx != null) {
            return (TraceContext)ctx.getLocal(ACTIVE_CONTEXT);
        }
        return null;
    }

    public ZipkinTracer(boolean closeTracer, Tracing tracing) {
        this(closeTracer, HttpTracing.newBuilder((Tracing)tracing).build());
    }

    public ZipkinTracer(boolean closeTracer, HttpTracing httpTracing) {
        this.closeTracer = closeTracer;
        this.tracing = httpTracing.tracing();
        this.clientHandler = HttpClientHandler.create((HttpTracing)httpTracing, HTTP_CLIENT_ADAPTER);
        this.httpServerHandler = HttpServerHandler.create((HttpTracing)httpTracing, HTTP_SERVER_ADAPTER);
        this.httpServerExtractor = httpTracing.tracing().propagation().extractor(HTTP_SERVER_GETTER);
        this.mapExtractor = this.tracing.propagation().extractor(MAP_GETTER);
    }

    public Tracing getTracing() {
        return this.tracing;
    }

    public <R> Span receiveRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        Span span;
        if (policy == TracingPolicy.IGNORE || operation.equalsIgnoreCase("publish")) {
            return null;
        }
        if (request instanceof HttpServerRequest) {
            HttpServerRequest httpReq = (HttpServerRequest)request;
            String traceId = httpReq.getHeader("X-B3-TraceId");
            if (traceId == null && policy == TracingPolicy.PROPAGATE) {
                return null;
            }
            span = this.httpServerHandler.handleReceive(this.httpServerExtractor, (Object)httpReq);
        } else {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Map.Entry<String, String> header : headers) {
                headerMap.put(header.getKey(), header.getValue());
            }
            TraceContextOrSamplingFlags extracted = this.mapExtractor.extract(headerMap);
            if (extracted.context() != null) {
                span = this.tracing.tracer().joinSpan(extracted.context());
            } else if (policy == TracingPolicy.ALWAYS) {
                span = this.tracing.tracer().newTrace();
                span.start();
            } else {
                return null;
            }
            span.kind(kind == SpanKind.RPC ? Span.Kind.SERVER : Span.Kind.CONSUMER);
            span.name(operation);
            ZipkinTracer.reportTags(request, tagExtractor, span);
        }
        context.putLocal(ACTIVE_SPAN, (Object)span);
        context.putLocal(ACTIVE_REQUEST, request);
        context.putLocal(ACTIVE_CONTEXT, (Object)span.context());
        return span;
    }

    public <R> void sendResponse(Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            context.removeLocal(ACTIVE_SPAN);
            if (response instanceof HttpServerResponse) {
                HttpServerRequest httpReq = (HttpServerRequest)context.getLocal(ACTIVE_REQUEST);
                this.httpServerHandler.handleSend((Object)httpReq, failure, span);
            } else {
                span.finish();
            }
            context.removeLocal(ACTIVE_REQUEST);
        }
    }

    public <R> BiConsumer<Object, Throwable> sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, final BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        Span span;
        if (policy == TracingPolicy.IGNORE) {
            return null;
        }
        TraceContext activeCtx = (TraceContext)context.getLocal(ACTIVE_CONTEXT);
        if (activeCtx == null) {
            if (policy != TracingPolicy.ALWAYS) {
                return null;
            }
            span = this.tracing.tracer().newTrace();
        } else {
            span = this.tracing.tracer().newChild(activeCtx);
            span.start();
        }
        if (request instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)request;
            SocketAddress socketAddress = httpRequest.remoteAddress();
            if (socketAddress != null && socketAddress.hostAddress() != null) {
                span.remoteIpAndPort(socketAddress.hostAddress(), socketAddress.port());
            }
            Propagation.Setter<HttpRequest, String> setter = new Propagation.Setter<HttpRequest, String>(){

                public void put(HttpRequest carrier, String key, String value) {
                    headers.accept(key, value);
                }

                public String toString() {
                    return "HttpClientRequest::putHeader";
                }
            };
            TraceContext.Injector injector = this.tracing.propagation().injector((Propagation.Setter)setter);
            this.clientHandler.handleSend(injector, (Object)httpRequest, span);
            return (resp, err) -> this.clientHandler.handleReceive((Object)((HttpResponse)resp), err, span);
        }
        span.kind(kind == SpanKind.RPC ? Span.Kind.CLIENT : Span.Kind.PRODUCER);
        span.name(operation);
        ZipkinTracer.reportTags(request, tagExtractor, span);
        TraceContext.Injector injector = this.tracing.propagation().injector(BiConsumer::accept);
        injector.inject(span.context(), headers);
        return (resp, err) -> {
            if (err != null) {
                span.error(err);
            }
            span.finish();
        };
    }

    private static <R> void reportTags(R request, TagExtractor<R> tagExtractor, Span span) {
        int len = tagExtractor.len(request);
        block12: for (int i = 0; i < len; ++i) {
            String name = tagExtractor.name(request, i);
            String value = tagExtractor.value(request, i);
            switch (name) {
                case "db.statement": {
                    span.tag("sql.query", value);
                    continue block12;
                }
                case "db.instance": {
                    span.remoteServiceName(value);
                    continue block12;
                }
                case "peer.address": {
                    Matcher matcher = P.matcher(value);
                    if (!matcher.matches()) continue block12;
                    String host = matcher.group(1);
                    int port = Integer.parseInt(matcher.group(2));
                    span.remoteIpAndPort(host, port);
                    continue block12;
                }
                case "message_bus.destination": {
                    span.remoteServiceName(value);
                }
            }
        }
    }

    public <R> void receiveResponse(Context context, R response, BiConsumer<Object, Throwable> payload, Throwable failure, TagExtractor<R> tagExtractor) {
        if (payload != null) {
            payload.accept(response, failure);
        }
    }

    public void close() {
        if (this.closeTracer) {
            this.tracing.close();
        }
    }
}

