/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import brave.test.http.ITHttpServer;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.tracing.zipkin.ZipkinTracer;
import io.vertx.tracing.zipkin.ZipkinTracingOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;

public class ZipkinHttpServerITTest
extends ITHttpServer
implements Handler<HttpServerRequest> {
    private Vertx vertx;
    private HttpServer server;
    private int port;

    protected void init() throws Exception {
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setTracingOptions((TracingOptions)new ZipkinTracingOptions(this.httpTracing)));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setTracingPolicy(TracingPolicy.ALWAYS)).requestHandler((Handler)this);
        CompletableFuture fut = new CompletableFuture();
        this.server.listen(0, "localhost", ar -> {
            if (ar.succeeded()) {
                fut.complete(((HttpServer)ar.result()).actualPort());
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        this.port = (Integer)fut.get(10L, TimeUnit.SECONDS);
    }

    public void readsExtra_newTrace() throws Exception {
        super.readsExtra_newTrace();
    }

    public void handle(HttpServerRequest req) {
        TraceContext ctx = ZipkinTracer.activeContext();
        switch (req.path()) {
            case "/extra": {
                req.response().end(ExtraFieldPropagation.get((TraceContext)ctx, (String)"user-id"));
                break;
            }
            case "/foo": {
                req.response().end("bar");
                break;
            }
            case "/exception": {
                req.response().setStatusCode(500).end();
                break;
            }
            case "/exceptionAsync": {
                req.endHandler(v -> req.response().setStatusCode(500).end());
                break;
            }
            case "/badrequest": {
                req.response().setStatusCode(400).end();
                break;
            }
            case "/": {
                if (req.method() != HttpMethod.OPTIONS) break;
                req.response().end("bar");
                break;
            }
            case "/async": {
                if (ZipkinTracer.activeSpan() == null) {
                    throw new IllegalStateException("couldn't read current span!");
                }
                req.endHandler(v -> req.response().end("bar"));
                break;
            }
            case "/items/1": {
                req.response().end("1");
                break;
            }
            case "/items/2": {
                req.response().end("2");
                break;
            }
            case "/child": {
                this.httpTracing.tracing().tracer().newChild(ctx).name("child").start().finish();
                req.response().end("happy");
                break;
            }
            default: {
                req.response().setStatusCode(404).end();
            }
        }
    }

    protected String url(String path) {
        return "http://127.0.0.1:" + this.port + path;
    }

    public void httpRoute() throws Exception {
    }

    public void httpRoute_nested() throws Exception {
    }

    public void httpRoute_async() throws Exception {
    }

    @After
    public void stop() throws Exception {
        if (this.vertx != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.vertx.close(ar -> latch.countDown());
            latch.await(10L, TimeUnit.SECONDS);
            this.vertx = null;
        }
    }
}

