/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.propagation.TraceContext;
import brave.test.http.ITHttpAsyncClient;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.tracing.zipkin.ZipkinTracingOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ZipkinHttpClientITTest
extends ITHttpAsyncClient<HttpClient> {
    private Vertx vertx;
    @Rule
    public TestName testName = new TestName();

    @Test
    @Ignore
    public void usesParentFromInvocationTime() throws Exception {
        super.usesParentFromInvocationTime();
    }

    @Test
    @Ignore
    public void customSampler() throws Exception {
        super.customSampler();
    }

    protected HttpClient newClient(int port) {
        if (this.vertx == null) {
            this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setTracingOptions((TracingOptions)new ZipkinTracingOptions(this.httpTracing)));
        }
        return this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(port).setDefaultHost("127.0.0.1").setTracingPolicy(TracingPolicy.ALWAYS));
    }

    protected void closeClient(HttpClient client) throws Exception {
        if (client != null) {
            client.close();
        }
    }

    protected void getAsync(HttpClient client, String pathIncludingQuery) throws Exception {
        this.request(client, pathIncludingQuery, null);
    }

    private CompletableFuture<HttpClientResponse> request(HttpClient client, String pathIncludingQuery, String body) {
        CompletableFuture<HttpClientResponse> fut = new CompletableFuture<HttpClientResponse>();
        Runnable task = () -> {
            Handler handler = res -> {
                if (res.succeeded()) {
                    fut.complete((HttpClientResponse)res.result());
                } else {
                    fut.completeExceptionally(res.cause());
                }
            };
            if (body == null) {
                client.request(new RequestOptions().setURI(pathIncludingQuery).setFollowRedirects(Boolean.valueOf(true)), ar -> {
                    if (ar.succeeded()) {
                        ((HttpClientRequest)ar.result()).send(handler);
                    } else {
                        handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            } else {
                client.request(HttpMethod.POST, pathIncludingQuery, ar -> {
                    if (ar.succeeded()) {
                        ((HttpClientRequest)ar.result()).send(Buffer.buffer((String)body), handler);
                    } else {
                        handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }
        };
        TraceContext traceCtx = this.currentTraceContext.get();
        if (traceCtx != null) {
            Context ctx = this.vertx.getOrCreateContext();
            ctx.putLocal("vertx.tracing.zipkin.active_context", (Object)traceCtx);
            ctx.runOnContext(v -> task.run());
        } else {
            task.run();
        }
        return fut;
    }

    protected void get(HttpClient client, String pathIncludingQuery) throws Exception {
        this.request(client, pathIncludingQuery, null).get(10L, TimeUnit.SECONDS);
        if (this.testName.getMethodName().equals("redirect")) {
            Thread.sleep(1000L);
        }
    }

    protected void post(HttpClient client, String pathIncludingQuery, String body) throws Exception {
        this.request(client, pathIncludingQuery, body).get(10L, TimeUnit.SECONDS);
    }

    public void close() throws Exception {
        if (this.vertx != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.vertx.close(ar -> latch.countDown());
            latch.await(10L, TimeUnit.SECONDS);
            this.vertx = null;
        }
        super.close();
    }

    protected String url(String path) {
        return "http://127.0.0.1:" + this.server.getPort() + path;
    }
}

