/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.authorizer;

import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import io.dropwizard.primer.auth.annotation.Authorize;
import io.dropwizard.primer.auth.authorizer.PrimerVertxAnnotationAuthorizer;
import io.dropwizard.primer.exception.PrimerException;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerVertxRoleAuthorizer
implements PrimerVertxAnnotationAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(PrimerVertxRoleAuthorizer.class);

    @Override
    public void authorize(JsonWebToken jwt, RoutingContext routingContext, Authorize authorize) throws PrimerException {
        List<String> authorizedRoles = Arrays.asList(authorize.value());
        if (authorizedRoles.contains(jwt.claim().getParameter("role"))) {
            return;
        }
        if (jwt.claim().getParameter("roles") != null && !Collections.disjoint(authorizedRoles, (List)jwt.claim().getParameter("roles"))) {
            return;
        }
        throw PrimerException.builder().status(401).errorCode("PR004").message("Unauthorized").recoverable(true).build();
    }

    PrimerVertxRoleAuthorizer() {
    }

    public static PrimerVertxRoleAuthorizerBuilder builder() {
        return new PrimerVertxRoleAuthorizerBuilder();
    }

    public static class PrimerVertxRoleAuthorizerBuilder {
        PrimerVertxRoleAuthorizerBuilder() {
        }

        public PrimerVertxRoleAuthorizer build() {
            return new PrimerVertxRoleAuthorizer();
        }

        public String toString() {
            return "PrimerVertxRoleAuthorizer.PrimerVertxRoleAuthorizerBuilder()";
        }
    }
}

