/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.InvalidSignatureException;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.MalformedJsonWebTokenException;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.TokenExpiredException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.base.Strings;
import feign.FeignException;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxAuthFilter {
    private static final Logger log = LoggerFactory.getLogger(VertxAuthFilter.class);
    private static final String AUTHORIZED_FOR_ID = "X-AUTHORIZED-FOR-ID";
    private static final String AUTHORIZED_FOR_SUBJECT = "X-AUTHORIZED-FOR-SUBJECT";
    private static final String AUTHORIZED_FOR_NAME = "X-AUTHORIZED-FOR-NAME";
    private static final String AUTHORIZED_FOR_ROLE = "X-AUTHORIZED-FOR-ROLE";
    protected final AuthType authType;
    protected final PrimerConfigurationHolder configHolder;
    protected final ObjectMapper objectMapper;

    protected VertxAuthFilter(AuthType authType, PrimerConfigurationHolder configHolder, ObjectMapper objectMapper) {
        this.authType = authType;
        this.configHolder = configHolder;
        this.objectMapper = objectMapper;
    }

    protected JsonWebToken authorize(RoutingContext routingContext, String token, AuthType authType) {
        String apiPath = routingContext.request().path();
        int index = apiPath.indexOf(47);
        String path = routingContext.request().path().substring(index + 1);
        return PrimerAuthorizationRegistry.authorize(path, routingContext.request().method().name(), token, authType);
    }

    protected Optional<String> getToken(RoutingContext routingContext) {
        String header = routingContext.request().headers().get("Authorization");
        log.info("Authorization Header: {}", (Object)header);
        if (header != null) {
            String rawToken = header.replaceAll(this.configHolder.getConfig().getPrefix(), "").trim();
            if (Strings.isNullOrEmpty((String)rawToken)) {
                return Optional.empty();
            }
            return Optional.of(rawToken);
        }
        return Optional.empty();
    }

    protected void stampHeaders(RoutingContext routingContext, JsonWebToken webToken) {
        String tokenType;
        switch (tokenType = (String)webToken.claim().getParameter("type")) {
            case "dynamic": {
                routingContext.request().headers().add(AUTHORIZED_FOR_ID, (String)webToken.claim().getParameter("user_id"));
                routingContext.request().headers().add(AUTHORIZED_FOR_SUBJECT, webToken.claim().subject());
                routingContext.request().headers().add(AUTHORIZED_FOR_NAME, (String)webToken.claim().getParameter("name"));
                routingContext.request().headers().add(AUTHORIZED_FOR_ROLE, (String)webToken.claim().getParameter("role"));
                break;
            }
            case "static": {
                routingContext.request().headers().add(AUTHORIZED_FOR_SUBJECT, webToken.claim().subject());
                routingContext.request().headers().add(AUTHORIZED_FOR_ROLE, (String)webToken.claim().getParameter("role"));
                break;
            }
            default: {
                log.warn("No auth header stamped for type: {}", (Object)tokenType);
            }
        }
    }

    protected void handleException(Throwable e, RoutingContext routingContext, String token) throws JsonProcessingException {
        if (e.getCause() instanceof TokenExpiredException || e instanceof TokenExpiredException) {
            log.error("Token Expiry Error: {}", (Object)e.getMessage());
            this.abortRequest(routingContext, Response.Status.PRECONDITION_FAILED, PrimerError.builder().errorCode("PR003").message("Expired").build());
        } else if (e.getCause() instanceof MalformedJsonWebTokenException || e instanceof MalformedJsonWebTokenException) {
            log.error("Token Malformed Error: {}", (Object)e.getMessage());
            this.abortRequest(routingContext, Response.Status.UNAUTHORIZED, PrimerError.builder().errorCode("PR004").message("Unauthorized").build());
        } else if (e.getCause() instanceof InvalidSignatureException || e instanceof InvalidSignatureException) {
            log.error("Token Signature Error: {}", (Object)e.getMessage());
            this.abortRequest(routingContext, Response.Status.UNAUTHORIZED, PrimerError.builder().errorCode("PR004").message("Unauthorized").build());
        } else if (e.getCause() instanceof FeignException) {
            log.error("Feign error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((FeignException)e.getCause()).status()), "PR000", e.getCause().getMessage(), token, false, routingContext);
        } else if (e instanceof FeignException) {
            log.error("Feign error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((FeignException)e).status()), "PR000", e.getMessage(), token, false, routingContext);
        } else if (e.getCause() instanceof PrimerException) {
            PrimerException primerException = (PrimerException)e.getCause();
            log.error("Primer error: {}", (Object)e.getMessage());
            log.debug("Primer error: {} status: {} errorCode: {} message: {} headers: {}", new Object[]{e.getMessage(), primerException.getStatus(), primerException.getErrorCode(), primerException.getMessage(), routingContext.request().headers()});
            this.handleError(Response.Status.fromStatusCode((int)((PrimerException)e.getCause()).getStatus()), ((PrimerException)e.getCause()).getErrorCode(), e.getCause().getMessage(), token, ((PrimerException)e.getCause()).isRecoverable(), routingContext);
        } else if (e instanceof PrimerException) {
            PrimerException primerException = (PrimerException)e;
            log.error("Primer error: {}", (Object)e.getMessage());
            log.debug("Primer error: {} status: {} errorCode: {} message: {} headers: {}", new Object[]{e.getMessage(), primerException.getStatus(), primerException.getErrorCode(), primerException.getMessage(), routingContext.request().headers()});
            this.handleError(Response.Status.fromStatusCode((int)((PrimerException)e).getStatus()), ((PrimerException)e).getErrorCode(), e.getMessage(), token, ((PrimerException)e).isRecoverable(), routingContext);
        } else {
            log.error("General error: ", e);
            this.handleError(Response.Status.INTERNAL_SERVER_ERROR, "PR000", "Error", token, false, routingContext);
        }
    }

    protected void abortRequest(RoutingContext routingContext, Response.Status status, PrimerError primerError) throws JsonProcessingException {
        routingContext.response().setStatusCode(status.getStatusCode()).setStatusMessage(primerError.getErrorCode()).end(this.objectMapper.writeValueAsString((Object)primerError));
    }

    protected void handleError(Response.Status status, String errorCode, String message, String token, boolean recoverable, RoutingContext requestContext) throws JsonProcessingException {
        switch (status) {
            case NOT_FOUND: 
            case UNAUTHORIZED: {
                if (!recoverable) {
                    PrimerAuthorizationRegistry.blacklist(token);
                }
                this.abortRequest(requestContext, Response.Status.UNAUTHORIZED, PrimerError.builder().errorCode("PR004").message("Unauthorized").build());
                break;
            }
            case FORBIDDEN: {
                if (!recoverable) {
                    PrimerAuthorizationRegistry.blacklist(token);
                }
                this.abortRequest(requestContext, Response.Status.FORBIDDEN, PrimerError.builder().errorCode("PR002").message("Forbidden").build());
                break;
            }
            default: {
                this.abortRequest(requestContext, status, PrimerError.builder().errorCode(errorCode).message(message).build());
            }
        }
    }
}

