/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.filter;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.auth.VertxAuthFilter;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import io.dropwizard.primer.util.CryptUtil;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.annotation.Priority;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
@Singleton
public class PrimerVertxAuthConfigFilter
extends VertxAuthFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerVertxAuthConfigFilter.class);
    private final SecretKeySpec secretKeySpec;
    private final GCMParameterSpec ivParameterSpec;

    public PrimerVertxAuthConfigFilter(PrimerConfigurationHolder configHolder, ObjectMapper objectMapper, SecretKeySpec secretKeySpec, GCMParameterSpec ivParameterSpec) {
        super(AuthType.CONFIG, configHolder, objectMapper);
        this.secretKeySpec = secretKeySpec;
        this.ivParameterSpec = ivParameterSpec;
    }

    @Metered(name="primer")
    public void filter(RoutingContext routingContext) throws IOException {
        if (!this.isEnabled() || this.isWhitelisted(routingContext)) {
            return;
        }
        Optional<String> token = this.getToken(routingContext);
        if (!token.isPresent()) {
            routingContext.response().setStatusCode(this.configHolder.getConfig().getAbsentTokenStatus().getStatusCode());
            routingContext.response().setStatusMessage("PR000");
            routingContext.response().end();
            this.objectMapper.writeValueAsString((Object)PrimerError.builder().errorCode("PR00").message("Bad Request").build());
        } else {
            try {
                String decryptedToken = CryptUtil.tokenDecrypt(token.get(), this.secretKeySpec, this.ivParameterSpec);
                JsonWebToken webToken = this.authorize(routingContext, decryptedToken, this.authType);
                log.info("Token : {}, Decrypted Token : {}, Web Token : {}", new Object[]{token, decryptedToken, webToken});
                this.stampHeaders(routingContext, webToken);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CompletionException) {
                    this.handleException(e.getCause().getCause(), routingContext, token.get());
                } else {
                    this.handleException(e.getCause(), routingContext, token.get());
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof PrimerException) {
                    this.handleException(e.getCause(), routingContext, token.get());
                }
                this.handleException(e, routingContext, token.get());
            }
        }
    }

    private boolean isEnabled() {
        return this.configHolder.getConfig().isEnabled() && this.configHolder.getConfig().getAuthTypesEnabled().getOrDefault((Object)AuthType.CONFIG, false) != false;
    }

    private boolean isWhitelisted(RoutingContext routingContext) {
        return PrimerAuthorizationRegistry.isWhilisted(routingContext.request().path());
    }

    public static PrimerVertxAuthConfigFilterBuilder builder() {
        return new PrimerVertxAuthConfigFilterBuilder();
    }

    public static class PrimerVertxAuthConfigFilterBuilder {
        private PrimerConfigurationHolder configHolder;
        private ObjectMapper objectMapper;
        private SecretKeySpec secretKeySpec;
        private GCMParameterSpec ivParameterSpec;

        PrimerVertxAuthConfigFilterBuilder() {
        }

        public PrimerVertxAuthConfigFilterBuilder configHolder(PrimerConfigurationHolder configHolder) {
            this.configHolder = configHolder;
            return this;
        }

        public PrimerVertxAuthConfigFilterBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerVertxAuthConfigFilterBuilder secretKeySpec(SecretKeySpec secretKeySpec) {
            this.secretKeySpec = secretKeySpec;
            return this;
        }

        public PrimerVertxAuthConfigFilterBuilder ivParameterSpec(GCMParameterSpec ivParameterSpec) {
            this.ivParameterSpec = ivParameterSpec;
            return this;
        }

        public PrimerVertxAuthConfigFilter build() {
            return new PrimerVertxAuthConfigFilter(this.configHolder, this.objectMapper, this.secretKeySpec, this.ivParameterSpec);
        }

        public String toString() {
            return "PrimerVertxAuthConfigFilter.PrimerVertxAuthConfigFilterBuilder(configHolder=" + this.configHolder + ", objectMapper=" + this.objectMapper + ", secretKeySpec=" + this.secretKeySpec + ", ivParameterSpec=" + this.ivParameterSpec + ")";
        }
    }
}

