/*
 * Decompiled with CFR 0.152.
 */
package com.vertx.maxmind.geoip2.model;

public class MaxMindInfo {
    private boolean anonymousIp;
    private boolean anonymousVpn;
    private boolean tor;
    private String city;
    private String state;
    private String stateIso;
    private String country;
    private String countryIso;
    private String postal;
    private String userType;
    private String connectionType;
    private String isp;
    private double latitude;
    private double longitude;
    private int accuracy;

    public static MaxMindInfoBuilder builder() {
        return new MaxMindInfoBuilder();
    }

    public boolean isAnonymousIp() {
        return this.anonymousIp;
    }

    public boolean isAnonymousVpn() {
        return this.anonymousVpn;
    }

    public boolean isTor() {
        return this.tor;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getStateIso() {
        return this.stateIso;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryIso() {
        return this.countryIso;
    }

    public String getPostal() {
        return this.postal;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getIsp() {
        return this.isp;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAnonymousIp(boolean anonymousIp) {
        this.anonymousIp = anonymousIp;
    }

    public void setAnonymousVpn(boolean anonymousVpn) {
        this.anonymousVpn = anonymousVpn;
    }

    public void setTor(boolean tor) {
        this.tor = tor;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setStateIso(String stateIso) {
        this.stateIso = stateIso;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setCountryIso(String countryIso) {
        this.countryIso = countryIso;
    }

    public void setPostal(String postal) {
        this.postal = postal;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxMindInfo)) {
            return false;
        }
        MaxMindInfo other = (MaxMindInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAnonymousIp() != other.isAnonymousIp()) {
            return false;
        }
        if (this.isAnonymousVpn() != other.isAnonymousVpn()) {
            return false;
        }
        if (this.isTor() != other.isTor()) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$stateIso = this.getStateIso();
        String other$stateIso = other.getStateIso();
        if (this$stateIso == null ? other$stateIso != null : !this$stateIso.equals(other$stateIso)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$countryIso = this.getCountryIso();
        String other$countryIso = other.getCountryIso();
        if (this$countryIso == null ? other$countryIso != null : !this$countryIso.equals(other$countryIso)) {
            return false;
        }
        String this$postal = this.getPostal();
        String other$postal = other.getPostal();
        if (this$postal == null ? other$postal != null : !this$postal.equals(other$postal)) {
            return false;
        }
        String this$userType = this.getUserType();
        String other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        String this$connectionType = this.getConnectionType();
        String other$connectionType = other.getConnectionType();
        if (this$connectionType == null ? other$connectionType != null : !this$connectionType.equals(other$connectionType)) {
            return false;
        }
        String this$isp = this.getIsp();
        String other$isp = other.getIsp();
        if (this$isp == null ? other$isp != null : !this$isp.equals(other$isp)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        return this.getAccuracy() == other.getAccuracy();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaxMindInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnonymousIp() ? 79 : 97);
        result = result * 59 + (this.isAnonymousVpn() ? 79 : 97);
        result = result * 59 + (this.isTor() ? 79 : 97);
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $stateIso = this.getStateIso();
        result = result * 59 + ($stateIso == null ? 43 : $stateIso.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $countryIso = this.getCountryIso();
        result = result * 59 + ($countryIso == null ? 43 : $countryIso.hashCode());
        String $postal = this.getPostal();
        result = result * 59 + ($postal == null ? 43 : $postal.hashCode());
        String $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        String $connectionType = this.getConnectionType();
        result = result * 59 + ($connectionType == null ? 43 : $connectionType.hashCode());
        String $isp = this.getIsp();
        result = result * 59 + ($isp == null ? 43 : $isp.hashCode());
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        result = result * 59 + this.getAccuracy();
        return result;
    }

    public String toString() {
        return "MaxMindInfo(anonymousIp=" + this.isAnonymousIp() + ", anonymousVpn=" + this.isAnonymousVpn() + ", tor=" + this.isTor() + ", city=" + this.getCity() + ", state=" + this.getState() + ", stateIso=" + this.getStateIso() + ", country=" + this.getCountry() + ", countryIso=" + this.getCountryIso() + ", postal=" + this.getPostal() + ", userType=" + this.getUserType() + ", connectionType=" + this.getConnectionType() + ", isp=" + this.getIsp() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", accuracy=" + this.getAccuracy() + ")";
    }

    public MaxMindInfo(boolean anonymousIp, boolean anonymousVpn, boolean tor, String city, String state, String stateIso, String country, String countryIso, String postal, String userType, String connectionType, String isp, double latitude, double longitude, int accuracy) {
        this.anonymousIp = anonymousIp;
        this.anonymousVpn = anonymousVpn;
        this.tor = tor;
        this.city = city;
        this.state = state;
        this.stateIso = stateIso;
        this.country = country;
        this.countryIso = countryIso;
        this.postal = postal;
        this.userType = userType;
        this.connectionType = connectionType;
        this.isp = isp;
        this.latitude = latitude;
        this.longitude = longitude;
        this.accuracy = accuracy;
    }

    public MaxMindInfo() {
    }

    public static class MaxMindInfoBuilder {
        private boolean anonymousIp;
        private boolean anonymousVpn;
        private boolean tor;
        private String city;
        private String state;
        private String stateIso;
        private String country;
        private String countryIso;
        private String postal;
        private String userType;
        private String connectionType;
        private String isp;
        private double latitude;
        private double longitude;
        private int accuracy;

        MaxMindInfoBuilder() {
        }

        public MaxMindInfoBuilder anonymousIp(boolean anonymousIp) {
            this.anonymousIp = anonymousIp;
            return this;
        }

        public MaxMindInfoBuilder anonymousVpn(boolean anonymousVpn) {
            this.anonymousVpn = anonymousVpn;
            return this;
        }

        public MaxMindInfoBuilder tor(boolean tor) {
            this.tor = tor;
            return this;
        }

        public MaxMindInfoBuilder city(String city) {
            this.city = city;
            return this;
        }

        public MaxMindInfoBuilder state(String state) {
            this.state = state;
            return this;
        }

        public MaxMindInfoBuilder stateIso(String stateIso) {
            this.stateIso = stateIso;
            return this;
        }

        public MaxMindInfoBuilder country(String country) {
            this.country = country;
            return this;
        }

        public MaxMindInfoBuilder countryIso(String countryIso) {
            this.countryIso = countryIso;
            return this;
        }

        public MaxMindInfoBuilder postal(String postal) {
            this.postal = postal;
            return this;
        }

        public MaxMindInfoBuilder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public MaxMindInfoBuilder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public MaxMindInfoBuilder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public MaxMindInfoBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public MaxMindInfoBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public MaxMindInfoBuilder accuracy(int accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public MaxMindInfo build() {
            return new MaxMindInfo(this.anonymousIp, this.anonymousVpn, this.tor, this.city, this.state, this.stateIso, this.country, this.countryIso, this.postal, this.userType, this.connectionType, this.isp, this.latitude, this.longitude, this.accuracy);
        }

        public String toString() {
            return "MaxMindInfo.MaxMindInfoBuilder(anonymousIp=" + this.anonymousIp + ", anonymousVpn=" + this.anonymousVpn + ", tor=" + this.tor + ", city=" + this.city + ", state=" + this.state + ", stateIso=" + this.stateIso + ", country=" + this.country + ", countryIso=" + this.countryIso + ", postal=" + this.postal + ", userType=" + this.userType + ", connectionType=" + this.connectionType + ", isp=" + this.isp + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", accuracy=" + this.accuracy + ")";
        }
    }
}

