/*
 * Decompiled with CFR 0.152.
 */
package com.vertx.maxmind.geoip2.filter;

import com.google.common.base.Strings;
import com.maxmind.geoip2.DatabaseProvider;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import com.vertx.maxmind.geoip2.config.MaxMindConfig;
import com.vertx.maxmind.geoip2.filter.MaxMindFilter;
import com.vertx.maxmind.geoip2.model.MaxMindInfo;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxMindVertxGeoIpRequestFilter
implements MaxMindFilter {
    private static final Logger log = LoggerFactory.getLogger(MaxMindVertxGeoIpRequestFilter.class);
    private final MaxMindConfig config;
    private final DatabaseProvider databaseProvider;

    public MaxMindVertxGeoIpRequestFilter(MaxMindConfig config, DatabaseProvider databaseProvider) {
        this.config = config;
        this.databaseProvider = databaseProvider;
    }

    public void handle(RoutingContext routingContext) {
        try {
            this.addMaxMindHeaders(routingContext);
            if (this.config.isMaxMindContext()) {
                this.addMaxMindContext(routingContext);
            }
        }
        catch (Exception e) {
            log.error("Exception while adding maxmind headers", (Throwable)e);
        }
    }

    private void addMaxMindHeaders(RoutingContext routingContext) throws IOException {
        MultiMap headers = routingContext.request().headers();
        String clientAddress = headers.get(this.config.getRemoteIpHeader());
        if (Strings.isNullOrEmpty((String)clientAddress)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Header: {} | Value: {}", (Object)this.config.getRemoteIpHeader(), (Object)clientAddress);
        }
        String[] addresses = clientAddress.split(",");
        InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
        if (!inetAddressValidator.isValid(addresses[0])) {
            log.warn("Invalid IP Address: {}", (Object)addresses[0]);
            return;
        }
        String clientIp = addresses[0];
        if (!Strings.isNullOrEmpty((String)clientIp)) {
            InetAddress address;
            try {
                address = InetAddress.getByName(clientIp);
            }
            catch (Exception e) {
                log.warn("Cannot resolve address: {} | Error: {}", (Object)clientIp, (Object)e.getMessage());
                return;
            }
            if (address == null) {
                log.warn("Cannot resolve address: {}", (Object)clientIp);
                return;
            }
            try {
                if (this.config.isEnterprise()) {
                    AnonymousIpResponse anonymousIpResponse;
                    EnterpriseResponse enterpriseResponse = this.databaseProvider.enterprise(address);
                    if (enterpriseResponse == null) {
                        return;
                    }
                    if (enterpriseResponse.getCountry() != null) {
                        this.addCountryInfo(enterpriseResponse.getCountry(), routingContext);
                    }
                    if (enterpriseResponse.getMostSpecificSubdivision() != null) {
                        this.addStateInfo(enterpriseResponse.getMostSpecificSubdivision(), routingContext);
                    }
                    if (enterpriseResponse.getCity() != null) {
                        this.addCityInfo(enterpriseResponse.getCity(), routingContext);
                    }
                    if (enterpriseResponse.getPostal() != null) {
                        this.addPostalInfo(enterpriseResponse.getPostal(), routingContext);
                    }
                    if (enterpriseResponse.getLocation() != null) {
                        this.addLocationInfo(enterpriseResponse.getLocation(), routingContext);
                    }
                    if (enterpriseResponse.getTraits() != null) {
                        this.addTraitsInfo(enterpriseResponse.getTraits(), routingContext);
                    }
                    if ((anonymousIpResponse = this.databaseProvider.anonymousIp(address)) != null) {
                        this.anonymousInfo(anonymousIpResponse, routingContext);
                    }
                } else {
                    switch (this.config.getType()) {
                        case "country": {
                            CountryResponse countryResponse = this.databaseProvider.country(address);
                            if (countryResponse == null || countryResponse.getCountry() == null) break;
                            this.addCountryInfo(countryResponse.getCountry(), routingContext);
                            break;
                        }
                        case "city": {
                            CityResponse cityResponse = this.databaseProvider.city(address);
                            if (cityResponse == null) break;
                            if (cityResponse.getCountry() != null) {
                                this.addCountryInfo(cityResponse.getCountry(), routingContext);
                            }
                            if (cityResponse.getMostSpecificSubdivision() != null) {
                                this.addStateInfo(cityResponse.getMostSpecificSubdivision(), routingContext);
                            }
                            if (cityResponse.getCity() != null) {
                                this.addCityInfo(cityResponse.getCity(), routingContext);
                            }
                            if (cityResponse.getPostal() != null) {
                                this.addPostalInfo(cityResponse.getPostal(), routingContext);
                            }
                            if (cityResponse.getLocation() == null) break;
                            this.addLocationInfo(cityResponse.getLocation(), routingContext);
                            break;
                        }
                        case "anonymous": {
                            AnonymousIpResponse anonymousIpResponse = this.databaseProvider.anonymousIp(address);
                            if (anonymousIpResponse == null) break;
                            this.anonymousInfo(anonymousIpResponse, routingContext);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("GeoIP Error: {}", (Object)e.getMessage());
            }
        }
    }

    private void addMaxMindContext(RoutingContext routingContext) {
        MultiMap headers = routingContext.request().headers();
        String anonymousIp = headers.get("X-MAXMIND-REQUEST-ANONYMOUS-IP");
        String anonymousVpn = headers.get("X-MAXMIND-REQUEST-ANONYMOUS-VPN");
        String tor = headers.get("X-MAXMIND-REQUEST-TOR-NODE");
        String city = headers.get("X-MAXMIND-REQUEST-CITY");
        String state = headers.get("X-MAXMIND-REQUEST-STATE");
        String stateIso = headers.get("X-MAXMIND-REQUEST-STATE-ISO");
        String postal = headers.get("X-MAXMIND-REQUEST-POSTAL-CODE");
        String connectionType = headers.get("X-MAXMIND-REQUEST-CONNECTION-TYPE");
        String userType = headers.get("X-MAXMIND-REQUEST-USER-TYPE");
        String country = headers.get("X-MAXMIND-REQUEST-COUNTRY");
        String countryIso = headers.get("X-MAXMIND-REQUEST-COUNTRY-ISO");
        String isp = headers.get("X-MAXMIND-REQUEST-ISP");
        String latitude = headers.get("X-MAXMIND-REQUEST-LATITUDE");
        String longitude = headers.get("X-MAXMIND-REQUEST-LONGITUDE");
        String accuracy = headers.get("X-MAXMIND-REQUEST-LOCATION-ACCURACY");
        String unknownValue = "UNKNOWN";
        MaxMindInfo maxMindInfo = MaxMindInfo.builder().anonymousIp(Strings.isNullOrEmpty((String)anonymousIp) ? false : Boolean.valueOf(anonymousIp)).anonymousVpn(Strings.isNullOrEmpty((String)anonymousVpn) ? false : Boolean.valueOf(anonymousVpn)).tor(Strings.isNullOrEmpty((String)tor) ? false : Boolean.valueOf(tor)).city(Strings.isNullOrEmpty((String)city) ? "UNKNOWN" : city).state(Strings.isNullOrEmpty((String)state) ? "UNKNOWN" : state).stateIso(Strings.isNullOrEmpty((String)state) ? "UNKNOWN" : stateIso).country(Strings.isNullOrEmpty((String)country) ? "UNKNOWN" : country).countryIso(Strings.isNullOrEmpty((String)country) ? "UNKNOWN" : countryIso).postal(Strings.isNullOrEmpty((String)postal) ? "UNKNOWN" : postal).connectionType(Strings.isNullOrEmpty((String)connectionType) ? "UNKNOWN" : connectionType).userType(Strings.isNullOrEmpty((String)userType) ? "UNKNOWN" : userType).isp(Strings.isNullOrEmpty((String)isp) ? "UNKNOWN" : isp).latitude(Strings.isNullOrEmpty((String)latitude) ? 0.0 : Double.valueOf(latitude)).longitude(Strings.isNullOrEmpty((String)longitude) ? 0.0 : Double.valueOf(longitude)).accuracy(Strings.isNullOrEmpty((String)accuracy) ? 0 : Integer.valueOf(accuracy)).build();
        routingContext.put("com.vertx.maxmind.geoip2.CONTEXT", (Object)maxMindInfo);
    }

    private void addCountryInfo(Country country, RoutingContext routingContext) {
        if (!Strings.isNullOrEmpty((String)country.getName())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-COUNTRY", this.toAscii(country.getName()));
        }
        if (!Strings.isNullOrEmpty((String)country.getIsoCode())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-COUNTRY-ISO", country.getIsoCode());
        }
    }

    private void addStateInfo(Subdivision subdivision, RoutingContext routingContext) {
        if (!Strings.isNullOrEmpty((String)subdivision.getName())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-STATE", this.toAscii(subdivision.getName()));
        }
        if (!Strings.isNullOrEmpty((String)subdivision.getIsoCode())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-STATE-ISO", subdivision.getIsoCode());
        }
    }

    private void addCityInfo(City city, RoutingContext routingContext) {
        if (!Strings.isNullOrEmpty((String)city.getName())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-CITY", this.toAscii(city.getName()));
        }
    }

    private void addPostalInfo(Postal postal, RoutingContext routingContext) {
        if (!Strings.isNullOrEmpty((String)postal.getCode())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-POSTAL-CODE", postal.getCode());
        }
    }

    private void addLocationInfo(Location location, RoutingContext routingContext) {
        if (location.getLatitude() != null) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-LATITUDE", String.valueOf(location.getLatitude()));
        }
        if (location.getLongitude() != null) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-LONGITUDE", String.valueOf(location.getLongitude()));
        }
        if (location.getAccuracyRadius() != null) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-LOCATION-ACCURACY", String.valueOf(location.getAccuracyRadius()));
        }
    }

    private void addTraitsInfo(Traits traits, RoutingContext routingContext) {
        if (!Strings.isNullOrEmpty((String)traits.getUserType())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-USER-TYPE", this.toAscii(traits.getUserType()));
        }
        if (!Strings.isNullOrEmpty((String)traits.getIsp())) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-ISP", this.toAscii(traits.getIsp()));
        }
        if (traits.getConnectionType() != null) {
            routingContext.request().headers().add("X-MAXMIND-REQUEST-CONNECTION-TYPE", this.toAscii(traits.getConnectionType().name()));
        }
        routingContext.request().headers().add("X-MAXMIND-REQUEST-LEGAL-PROXY", String.valueOf(traits.isLegitimateProxy()));
    }

    private void anonymousInfo(AnonymousIpResponse anonymousIpResponse, RoutingContext routingContext) {
        routingContext.request().headers().add("X-MAXMIND-REQUEST-ANONYMOUS-IP", String.valueOf(anonymousIpResponse.isAnonymous()));
        routingContext.request().headers().add("X-MAXMIND-REQUEST-ANONYMOUS-VPN", String.valueOf(anonymousIpResponse.isAnonymousVpn()));
        routingContext.request().headers().add("X-MAXMIND-REQUEST-TOR-NODE", String.valueOf(anonymousIpResponse.isTorExitNode()));
    }

    private String toAscii(String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            return input.replaceAll("[^\\x20-\\x7e]", "");
        }
        return input;
    }
}

