/*
 * Decompiled with CFR 0.152.
 */
package com.vertx.maxmind.geoip2;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseProvider;
import com.maxmind.geoip2.DatabaseReader;
import com.vertx.maxmind.geoip2.config.MaxMindConfig;
import com.vertx.maxmind.geoip2.filter.MaxMindFilter;
import com.vertx.maxmind.geoip2.filter.MaxMindVertxGeoIpRequestFilter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MaxMindVertxBundle {
    private static final Logger log = LoggerFactory.getLogger(MaxMindVertxBundle.class);
    public static final String MAX_MIND_CONTEXT_KEY = "com.vertx.maxmind.geoip2.CONTEXT";
    private final MaxMindConfig config;
    private MaxMindFilter maxMindFilter;
    private DatabaseProvider databaseProvider;

    @Inject
    public MaxMindVertxBundle(MaxMindConfig aConfig) {
        this.config = aConfig;
    }

    public void init() {
        this.initializeDataBase();
        this.maxMindFilter = new MaxMindVertxGeoIpRequestFilter(this.config, this.databaseProvider);
        log.info("Maxmind bundle init success");
    }

    private void initializeDataBase() {
        try {
            this.databaseProvider = new DatabaseReader.Builder(new File(this.config.getDatabaseFilePath())).withCache(new NodeCache(){
                private Cache<Integer, JsonNode> cache;
                {
                    this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)MaxMindVertxBundle.this.config.getCacheTTL(), TimeUnit.SECONDS).maximumSize((long)MaxMindVertxBundle.this.config.getCacheMaxEntries()).recordStats().build();
                }

                public JsonNode get(int i, NodeCache.Loader loader) throws IOException {
                    try {
                        return (JsonNode)this.cache.get((Object)i, () -> loader.load(i));
                    }
                    catch (ExecutionException e) {
                        return null;
                    }
                }
            }).build();
        }
        catch (IOException e) {
            String message = "Error initializing GeoIP database";
            log.error("Error initializing GeoIP database", (Throwable)e);
            throw new RuntimeException("Error initializing GeoIP database");
        }
    }

    public MaxMindFilter getMaxMindFilter() {
        return this.maxMindFilter;
    }
}

