;;; 02/16/14  18:57 by miner -- incomplete ideas
;;; want a macro at compile time that creates a delay
;;; that is resolved once at runtime and de-reffed potentially many times
(ns miner.junk
  (:require [miner.wilkins :as w]))


;; for use at runtime as opposed to readtime

#_ (defmacro feature-cond 
  ([] nil)
  ([fspec form] `(if (provided-test ~fspec) ~form nil))
  ([fspec form & more] `(if (provided-test ~fspec) ~form (feature-cond ~@more))))


#_ (defmacro vfc
  ([] nil)
  ([fspec form]
     (let [dtest (gensym "W__")]
       (intern *ns* dtest (delay `(w/provided-test ~fspec)))
       `(if (deref ~dtest)
          ~form
          nil)))
  ([fspec form & more] 
     (let [dtest (gensym)]
       (intern *ns* dtest (delay `(w/provided-test ~fspec)))
       `(if (deref ~dtest)
          ~form
          (vfc ~@more)))))

;;; Or a way to set a trap if the compiled env is incompatible with the runtime env


(defmacro dtest
  ([] nil)
  ([fspec form]
     (let [dtest (gensym "W__")]
       `(intern *ns* '~dtest (delay `(list :delayed '~fspec '~form))))))


(defmacro checksym [sym]
  `(when-not (or (resolve '~sym) (special-symbol? '~sym))
     (throw (ex-info (str "Runtime environment is missing " '~sym)
                     {:missing '~sym :compilation ~*clojure-version*}))))

;; If AOT the *compile-files* will be true.  But also, when first loading a file.

;; to be used at the top-level
(defmacro loadtime-check [sym]
  (if *compile-files*
    `(var-check ~sym)
    `(comment ~sym expected)))

(defmacro throw-if-not-clojure-version 
  ([] `(throw-if-not-clojure-version ~*clojure-version*))
  ([version]
     (when *compile-files*
       `(when (not= *clojure-version* ~version)
          (throw (ex-info "AOT compiled with old " ~version)
                       {:old ~version
                        :current *clojure-version*})))))
  
  



;; just examples of kind of output code I want from one macro invocation
#_ (def dtest1 (delay (provided-feature (and clj1.5+ jdk1.6+))))

#_ (if @dtest1
  (println "Good version")
  (throw (ex-info "Bad version" {:bad :version :requires :clojure-1.5})))



(defn foo [x]
  (println "foo" x)
  (number? x))

;; makes new delay everytime bar is called
(defn bar []
  (if (deref (delay (foo 11)))
    :ok
    :bad))

;; makes delay once and reuses it
(let [ddd (delay (foo 13))]
  (defn baz []
    (if (deref ddd)
      :good
      :bad)))


(def ddd (delay (foo 9)))

(defn doof []
  (if (deref ddd)
    :ok
    :bad))

;; need a with-features macro

(with-runtime-features [foo-ish (and clj1.5+ jdk1.6+)
                        bar-ish @when-some]
  (defn foo []
    (if @foo-ish
      :good
      :bad)))

(with-load-time-features
  (defn foo []
    (if (feature? (and clj1.5+ jdk1.6+))
      :good
      :bad)))

(def W__13 (delay (provided-test (and clj1.5+ jdk1.6+))))
(defn foo []
  (if (deref W__13)
    :good
    :bad))





(defn current-ns-str []
  (name (ns-name *ns*)))

(defn namespace? [ns]
  (instance? clojure.lang.Namespace ns))

;; ns can be a real namespace, a string or a symbol
;; sym can be a symbol or a string
;; when the namespace is not specified, the current *ns* is used
;; result is always a qualified symbol
(defn qualified-symbol 
  ([sym] (cond (nil? sym) nil
               (string? sym) (symbol (current-ns-str) sym)
               (namespace sym) sym
               :else (symbol (current-ns-str) (name sym))))
  ([ns sym] (cond (nil? sym) nil
                  (nil? ns) (qualified-symbol sym)
                  (namespace? ns) (symbol (name (ns-name ns)) (name sym))
                  :else (symbol (name ns) (name sym)))))



;; hacky stuff that doesn't exactly work.  Trying to handle alias ns resolution
;; (defn fully-qualified-namespace [sym]
;;   (->> (resolve sym) meta :ns))
;; 
;; 
;;         (when-let [nspace (fully-qualified-namespace x)]
;;           (when (not= (namespace x) (name (ns-name nspace)))
;;             (ns-resolve nspace (symbol (name x)))))
