(ns miner.junktest)
  

(defmacro throw-if-not-clojure-version 
  ([] `(throw-if-not-clojure-version ~*clojure-version*))
  ([version]
       `(when (and (not *compile-files*) (not= *clojure-version* ~version))
          (throw (ex-info "Incompatible Clojure versions"
                          {:compiled ~version
                           :current *clojure-version*})))))
 
(throw-if-not-clojure-version)
;(throw-if-not-clojure-version {:major 1, :minor 5, :incremental 1})

(if *compile-files* 
  (println "compiling with" (clojure-version))
  (println "*compiled-files* =" *compile-files*))

(println "loaded with" (clojure-version))





