;;; 01/26/15  09:53 by miner -- don't need this anymore

(defn- compute-class->factory
  "Returns the map-style record factory for the `record-class`."
  [record-class]
  (let [cname (record-name record-class)
        dot (.lastIndexOf ^String cname ".")]
    (when (pos? dot)
      (resolve (symbol (str (subs cname 0 dot) "/map->" (subs cname (inc dot))))))))


;; borrowed from clojure.core.reducers
(defmacro ^:private compile-if
  "Evaluate `exp` and if it returns logical true and doesn't error, expand to
  `then`.  Else expand to `else`.

  (compile-if (Class/forName \"java.util.concurrent.ForkJoinTask\")
    (do-cool-stuff-with-fork-join)
    (fall-back-to-executor-services))"
  [exp then else]
  (if (try (eval exp)
           (catch Throwable _ false))
    `(do ~then)
    `(do ~else)))

;; java.lang.ClassValue requires JDK 1.7.  If it's not available at compile time, we
;; have to memoize the factory call.  The check for *compile-files* prevents AOT compilation
;; from capturing the JDK dependency at AOT compile-time, which could cause a failure if the
;; resulting JAR is later used with an older JDK at runtime.

(compile-if (and (not *compile-files*) (Class/forName "java.lang.ClassValue"))

 (let [record-factory-classvalue (proxy [java.lang.ClassValue] []
                                    (computeValue [c]
                                      (when (.isAssignableFrom clojure.lang.IRecord c) 
                                        (compute-class->factory c))))]
   (defn class->factory 
     "Returns the map-style record factory for the `record-class`."
     [^Class record-class]
     (.get record-factory-classvalue record-class)))

 (def class->factory (memo/lru compute-class->factory)) )


