(ns miner.strgen.caseins
  (:require [miner.strgen :as strgen]
            [clojure.test.check.generators :as gen]
            [clojure.string :as str]))

(defn gen-mixed-case-GOOD [s]
  (gen/fmap (fn [ups] (str/join (map (fn [c up?]
                                       (if up? (str/upper-case c) (str/lower-case c)))
                                     (seq s)
                                     ups)))
            (gen/vector gen/boolean (count s))))



(defn gen-mixed-case [s]
  (gen/fmap (fn [ups] (str/join (map (fn [low up up?] (if up? up low))
                                     (str/lower-case s)
                                     (str/upper-case s)
                                     ups)))
            (gen/vector gen/boolean (count s))))

(defn gen-mixed-case-SLOWER [s]
  (gen/fmap str/join (apply gen/tuple
                            (map gen/elements (map list
                                                   (str/lower-case s)
                                                   (str/upper-case s))))))



(defn gen-case-insensitive-ORIG [s]
  (gen/one-of [(gen/return s)
               (gen/return (str/capitalize s))
               (gen/return (str/upper-case s))
               (gen/return (str/lower-case s))
               (gen-mixed-case s)]))

(defn gen-case-insensitive_WORKS [s]
  (gen/one-of [(gen/elements [s (str/capitalize s) (str/upper-case s) (str/lower-case s)])
               (gen-mixed-case s)]))






(defn gen-case-insensitive [s]
  (let [ups (str/upper-case s)
        lows (str/lower-case s)]
    (gen/one-of [(gen/elements [s (str/capitalize s) ups lows])
                 (gen/fmap (fn [bs]
                             (str/join (map (fn [b low up] (if b up low)) bs lows ups)))
                           (gen/vector gen/boolean (count s)))])))


;; new for public use
(defn case-insensitive-string-generator
  "Like `string-generator` but case-insensitive so it generates upper and lowercase
  variations on the given regex."
  
  ([regex] (gen/bind (strgen/string-generator regex) gen-case-insensitive))

  ([regex or-more-limit]
   (gen/bind (strgen/string-generator regex or-more-limit) gen-case-insensitive)))


