
;; Conflict between generators and convenience.  Seems like it would be nice to allow and
;; int to make a date.  But how would that be distinguished from the more general tag/print
;; rep?  I guess we could imagine a tag reader that accepts #inst MILLI as a Java milli
;; (???)


(defmethod make-tag-generator 'inst
  ([context _] (gen/fmap #(java.util.Date. ^long %) gen/int))
  ([context _ regex-constraint]
   ;; 1970-01-01T00:00:01.835-00:00
   (let [sdf (java.text.SimpleDateFormat. "yyyy-MM-dd'T'HH:mm:ss.SSSXXX")]
     (gen/fmap #(.parse ^java.text.SimpleDateFormat sdf ^String %)
               (mk-str context regex-constraint)))))

;; useful but not compatible with conformance test (which expects a string)
;;  ([context _ milli-constraint] (gen/fmap #(java.util.Date. ^long %)  (mk-gen context milli-constraint)))



;; old scheme of actually trying to read the value.  Clever, but not compatible with
;; generator approach.  And maybe too expensive.  New scheme is to use the edn-value and
;; match that.  Lower fidelity but probably faster.  Also, works nicely with generators.

(defn tag-reader-constant [tag val]
  ;; returns the tagged literal constant or nil if not applicable
  ;; allow nil value in reader map to defeat a tag
  (when (and val (symbol? tag) (literal-or-quoted? val))
    (let [reader-map (first (filter #(contains? % tag)
                                    (list *herbert-readers* *data-readers*
                                          default-data-readers)))]
      (if-let [reader (get reader-map tag)]
        (reader (dequote val))
        (let [default-reader (tag/some-tag-reader *herbert-default-tag-reader*
                                                  tag/record-tag-reader
                                                  tag/->TaggedValue)]
          (default-reader tag (dequote val)))))))

(defn mk-tag-WAS
  ;; tag could be a symbol (exact match) or a string/regex to match pr-str of item's actual tag
  ([tag] (if (symbol? tag) 
           (mkprb #(= (tag/edn-tag %) tag) (list 'tag tag))
           (mkprb #(regex-sym-match? tag (tag/edn-tag %)) (list 'tag tag))))

  ([tag valpat extensions]
   (if-let [data-constant (tag-reader-constant tag valpat)]
     (sp/mklit data-constant)
     (let [vrule (when valpat (mkconstraint valpat extensions))]
       (fn [input bindings context memo]
         (let [item (first input)
               ival (tag/edn-value item)
               itag (tag/edn-tag item)]
           (if (if (symbol? tag) (= itag tag) (regex-sym-match? tag itag))
             (if vrule
               (let [res (vrule (list ival) bindings context memo)]
                 (if (sp/failure? res)
                   res
                   (sp/succeed item [item] (rest input) (merge bindings (:b res)) memo)))
               (sp/succeed item [item] (rest input) bindings memo))
             (sp/fail (str "Not tagged " tag) memo))))))))
