;;; Extra junk

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; SP rule takes 4 args:   input, bindings, context and memo.
;; Or it can be called like a fn with a sequence as input, and it parses as much as possible
;; 
;; (defn succeed
;;   [return sreturn input bindings memo]
;;   {:i input :b bindings :r return :s sreturn :m memo})

;; sp/end terminates a collection rule so that nothing else is allowed



;; "ac" short for "accept" -- a rule that accepts whatever
(sp/defrule ac-int (sp/mkpr integer?))
(sp/defrule ac-int* (sp/mkzom ac-int))
(sp/defrule ac-int+ (sp/mk1om ac-int))
(sp/defrule ac-int? (sp/mkopt ac-int))

(sp/defrule ac-int*end (sp/mkseq (sp/mkzom ac-int) sp/end))

;; make a macro to expand the quantified versions from the mkpr

(sp/defrule ac-vec (sp/mkpr vector?))
(sp/defrule ac-vec* (sp/mkzom ac-vec))
(sp/defrule ac-vec+ (sp/mk1om ac-vec))
(sp/defrule ac-vec? (sp/mkopt ac-vec))

(sp/defrule ac-sym (sp/mkpr symbol?))
(sp/defrule ac-sym* (sp/mkzom ac-sym))
(sp/defrule ac-sym+ (sp/mk1om ac-sym))
(sp/defrule ac-sym? (sp/mkopt ac-sym))

(sp/defrule ac-two-by-two (sp/mkseq ac-int ac-int ac-sym ac-sym))


(sp/defrule ac-sym-int-alt (sp/mk1om (sp/mkseq ac-sym ac-int)))

;; Note the rules are greedy and won't backtrack on failure.  Once a subrule succeeds, it's
;; committed.  That's it.  Some ambiguous `sym? sym int` might fail on a `sym int`, but `sym sym?
;; int` would succeed.
;;
;; This is intentional.  See the paper on PEGs. ? * + are greedy.  But you can use & to be
;; non-greedy.
;; 
;; http://pdos.csail.mit.edu/papers/parsing:popl04.pdf

;; surprisingly no backtracking
(sp/defrule ac-sosi (sp/mkseq ac-sym? ac-sym ac-int))

;; better
(sp/defrule ac-ssi (sp/mkseq ac-sym ac-sym? ac-int))


;; Issue, parsing mksub ignores extra junk.  Have to use my sp/end to force termination with nothing
;; extra.



(sp/defrule ac-iopt-si+ (sp/mkseq ac-int? (sp/mk1om (sp/mkseq ac-sym ac-int+))))

(sp/defrule ac-s-vint (sp/mkseq ac-sym (sp/mksub ac-int+)))

(sp/defrule ac-vsi (sp/mksub (sp/mkseq (sp/mkzom (sp/mkseq ac-sym ac-int)) sp/end)))

(sp/defrule ac-vsix (sp/mksub (sp/mkzom (sp/mkseq ac-sym ac-int))))                    

(sp/defrule ac-vsix2 (sp/mkret (sp/mkbind ac-vsix :contents)
                              (fn [b con] (vec (:contents b)))))

(sp/defrule ac-vsix1  (sp/mkbind ac-vsix :contents))
                     

(sp/defrule ac-s-vsix-s (sp/mkseq ac-sym (sp/mksub (sp/mkzom (sp/mkseq ac-sym ac-int))) ac-sym))


(sp/defrule ac-svs (sp/mkseq ac-sym ac-vsix ac-sym))

(sp/defrule ac-map (sp/mkpr map?))
(sp/defrule ac-map* (sp/mkzom ac-map))


(defn plant? [p]
  (and (map? p) 
       (when-let [id (:id p)]
         (zero? (mod (count id) 4)))))


(sp/defrule ac-plant* (sp/mkseq (sp/mkzom (sp/mkpr plant?)) sp/end))

