(ns miner.herbert.recursive
  (:require [squarepeg.core :as sp]))

;; Problem with recursive rule

(declare mcon)

(def mint (sp/mkpr integer?))

(def mvec (sp/mksub (sp/mk1om mcon)))

(def mcon (sp/mkalt mint mvec))

#_ (mcon '(42) {} {} {})
;=> {:i (), :b {}, :r 42, :s [42], :m {}}

#_ (mcon '([42]) {} {} {})
; IllegalStateException Attempting to call unbound fn: #'miner.herbert.recursive/mcon
; clojure.lang.Var$Unbound.throwArity (Var.java:43)





(declare xcon)
;; work-around by using var
(def xcon1 #'xcon)

(def xint (sp/mkpr integer?))

(def xvec (sp/mksub (sp/mk1om xcon1)))

(def xcon (sp/mkalt xint xvec))

#_ (xcon '(42) {} {} {})
;=> {:i (), :b {}, :r 42, :s [42], :m {}}

#_ (xcon '([42]) {} {} {})
;=> {:i (), :b {}, :r [42], :s [42], :m {}}
