(require 'leiningen.core.eval)

(def http-port 3449)


(defproject com.vadelabs/vds "0.0.0-SNAPSHOT"
  :description "Vade Design System. It is built using ClojureScript, Re-Frame. It follows atomic design pattern for better and scalable directory structure."
  :url "https://open.vadelabs.com/vds"
  :scm {:name "git" :url "https://gitlab.com/vadelabs/vadecljs/vds.git"}
  :license {:name "MIT"}

  :codox {:output-path "doc"
          :language :clojurescript
          :source-paths ["src"]
          :source-uri "https://github.com/metosin/reitit/{version}/{filepath}#L{line}"
          :metadata {:doc/format :markdown}}
  
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/clojurescript "1.10.520"
                  :exclusions [com.google.javascript/closure-compiler-unshaded
                               org.clojure/google-closure-library]]
                 [reagent "0.9.0-rc2"]
                 [re-frame "0.11.0-rc2"]
                 [day8.re-frame/tracing "0.5.1"]
                 [thheller/shadow-cljs "2.8.66"]
                 [cljs-ajax "0.7.3"]
                 [com.andrewmcveigh/cljs-time "0.5.2"]
                 [bidi "2.1.6"]
                 [kibu/pushy "0.3.8"]
                 [stylefy "1.14.0"]
                 [org.clojure/core.async "0.4.500"]]

  :plugins [[lein-shadow "0.1.6"]
            [lein-codox "0.10.7"]]
  
  :profiles {:dev      {:dependencies [[day8.re-frame/http-fx "0.1.6"]
                                       [day8.re-frame/re-frame-10x "0.4.4"]
                                       [nubank/workspaces "1.0.13"]]}
             :demo     {}
             :dev-run  {}
             :prod-run {}
             :dev-test {}}

  :source-paths ["src"]

  :clean-targets ^{:protect false} [:target-path
                                    "shadow-cljs.edn"
                                    "package.json"
                                    "package-lock.json"
                                    "public/compiled_dev"
                                    "public/compiled_prod"
                                    "public/compiled_test"]

  :deploy-repositories [["clojars" {:url "https://clojars.org/repo"
                                    :creds :gpg}]]

  :shadow-cljs {:nrepl        {:port 7777}
                :builds       {:demo {:target :browser
                                      :output-dir "public/js"
                                      :asset-path "/js"

                                      :modules {:main {:init-fn com.vadelabs.vds.demo.core/init}}

                                      :dev {:compiler-options {:closure-defines {re-frame.trace/trace-enabled? true
                                                                                 day8.re-frame.tracing/trace-enabled? true
                                                                                 re_frame.trace.trace_enabled_QMARK_  true}}}

                                      :devtools {:http-root   "public"
                                                 :http-port   ~http-port
                                                 :after-load  vds.usage.core/mount-root
                                                 :preloads    [day8.re-frame-10x.preload]}}
                               :cards {:target     nubank.workspaces.shadow-cljs.target
                                       :ns-regexp  "tests*|cards*"
                                       :output-dir "public/js/workspaces"
                                       :asset-path "/js/workspaces"
                                       :preloads   [] ; optional, list namespaces to be pre loaded
                                       }}}

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]

  :aliases          {;; *** DEV ***
                     
                     "dev-auto"   ["with-profile" "+dev-run,+demo" "do"
                                   ["clean"]
                                   ["shadow" "watch" "demo" "cards"]]

                     ;; *** PROD ***
                     
                     "prod-once"  ["with-profile" "+prod-run,+demo,-dev" "do"
                                   ["clean"]
                                   ["shadow" "release" "demo"]]})