(ns com.vadelabs.vds.ions.themes
  (:require [com.vadelabs.vds.utils :as vdu]
            [com.vadelabs.vds.ions.breakpoints :refer [breakpoints]]
            [com.vadelabs.vds.ions.colors :refer [colors]]
            [com.vadelabs.vds.ions.typography :refer [typography]]
            [com.vadelabs.vds.ions.sizing :refer [sizing]]
            [com.vadelabs.vds.ions.lighting :refer [lighting]]
            [com.vadelabs.vds.ions.borders :refer [borders]]
            [com.vadelabs.vds.ions.animation :refer [animation]]
            [com.vadelabs.vds.ions.primitives :refer [primitives]]
            [com.vadelabs.vds.ions.tokens :as tokens]))

(defn theme-builder
  [& args]
  (let [{:keys [primitives overrides]
         :or {primitives (primitives (tokens/colors))}} (vdu/extract-args args)
        theme {:breakpoints (breakpoints)
               :colors (colors primitives)
               :typography (typography primitives)
               :sizing (sizing)
               :lighting (lighting)
               :borders (borders)
               :animation (animation)
               :direction "auto"
               :z-index  {:modal 2000}}]
    (vdu/deep-merge theme overrides)))