(ns com.vadelabs.vds.demo.events
  (:require
   [com.vadelabs.vds.demo.db :refer [default-db]]
   [re-frame.core :refer [reg-event-db reg-event-fx reg-fx inject-cofx trim-v after path debug]]
   [day8.re-frame.tracing :refer-macros [fn-traced]]))

(reg-event-fx
 :initialize-db
 [(inject-cofx :local-store-user)]
 (fn-traced [{:keys [local-store-user]} _]
            {:db (assoc default-db :user local-store-user)}))

(reg-event-fx
 :set-active-page
 (fn-traced [{:keys [db]} [_ {:keys [page]}]]
            (let [set-page (assoc db :active-page page)]
              (case page
                :landing {:db set-page}
                :login {:db set-page}))))