(ns com.vadelabs.vds.demo.db
  (:require [cljs.reader]
            [re-frame.core :refer [reg-cofx]]
            [com.vadelabs.vds.ions.themes :refer [theme-builder]]))


(def default-db
  {:active-page :landing
   :theme (theme-builder)})

(def app-user-key "vade-user")

(defn set-user-ls
  [user]
  (.setItem js/localStorage app-user-key (str user)))  ;; sorted-map written as an EDN map

(defn remove-user-ls
  []
  (.removeItem js/localStorage app-user-key))


(reg-cofx
 :local-store-user
 (fn [cofx _]
   (assoc cofx :local-store-user
          (into (sorted-map)
                (some->> (.getItem js/localStorage app-user-key)
                         (cljs.reader/read-string))))))