(ns com.vadelabs.vds.atoms.cards.block
  (:require [reagent.core :as reagent]
            [re-frame.core :as rf]
            [nubank.workspaces.core :as ws]
            [nubank.workspaces.card-types.react :as ct.react]
            [com.vadelabs.vds.atoms.block :refer [vda-block]]
            [com.vadelabs.vds.ions.themes :refer [theme-builder]]))


;; --- Domino 1 - Event Dispatch ---
(defn dispatch-initialize-theme
  []
  (rf/dispatch-sync [:initialize-db]))

(defonce initialize (dispatch-initialize-theme))

;; --- Domino 2 - Event Handlers ---
(rf/reg-event-fx
 :initialize-db
 (fn [{:keys [db]}]
   {:db (assoc db :theme (theme-builder))}))

;; --- Domino 4 - Query ---
(rf/reg-sub
 :theme
 (fn [db _]
   (:theme db)))

;; --- Domino 5 - View Functions ---
(defn vda-block-basic
  []
  [:div
   [vda-block "First Element"]
   [vda-block {:padding-top "100px"} "Padding top applied to this element"]])

;; --- Workspace Cards ---
(ws/defcard vda-block-basic
  (ct.react/react-card
   (reagent/as-element (vda-block-basic))))