(ns vds.ions.themes
  (:require [vds.utils :as vdu]
            [vds.ions.breakpoints :refer [breakpoints]]
            [vds.ions.colors :refer [colors]]
            [vds.ions.typography :refer [typography]]
            [vds.ions.sizing :refer [sizing]]
            [vds.ions.lighting :refer [lighting]]
            [vds.ions.borders :refer [borders]]
            [vds.ions.animation :refer [animation]]
            [vds.ions.primitives :refer [primitives]]
            [vds.ions.tokens :as tokens]))

(defn theme-builder
  [& args]
  (let [{:keys [primitives overrides]
         :or {primitives (primitives (tokens/colors))}} (vdu/extract-args args)
        theme {:breakpoints (breakpoints)
               :colors (colors primitives)
               :typography (typography primitives)
               :sizing (sizing)
               :lighting (lighting)
               :borders (borders)
               :animation (animation)
               :direction "auto"
               :z-index  {:modal 2000}}]
    (vdu/deep-merge theme overrides)))