(ns com.vadelabs.utils-str.interface
  (:refer-clojure :exclude [str replace format concat])
  (:require
   [com.vadelabs.utils-str.regexp :as regexp]
   [com.vadelabs.utils-str.string :as ustr]
   [com.vadelabs.utils-str.template :as template]))

(defmacro str
  [& params]
  `(ustr/concat ~@params))

(defmacro concat
  [& params]
  `(ustr/concat ~@params))

(defmacro ffmt
  [s & params]
  `(ustr/ffmt ~s ~@params))

(defn format
  [& args]
  (apply ustr/format args))

(defn upper
  [& args]
  (apply ustr/upper args))

(defn blank?
  [& args]
  (apply ustr/blank? args))

(defn starts-with?
  [& args]
  (apply ustr/starts-with? args))
(defn split
  [& args]
  (apply ustr/split args))

(defn join
  [& args]
  (apply ustr/join args))

(defn index-of
  [& args]
  (apply ustr/index-of args))

(defn capital
  [& args]
  (apply ustr/capital args))

(defn camel
  [& args]
  (apply ustr/camel args))

(defn css-selector
  [& args]
  (apply ustr/css-selector args))

(defn ends-with?
  [& args]
  (apply ustr/ends-with? args))

(defn lower
  [& args]
  (apply ustr/lower args))
(defn replace
  [& args]
  (apply ustr/replace args))

(defn replace-first
  [& args]
  (apply ustr/replace-first args))

(defn trim
  [& args]
  (apply ustr/trim args))

(defn ltrim
  [& args]
  (apply ustr/ltrim args))

(defn rtrim
  [& args]
  (apply ustr/rtrim args))
(defn includes?
  [& args]
  (apply ustr/includes? args))

(defn split-lines
  [& args]
  (apply ustr/lines args))

(defn lines
  [& args]
  (apply ustr/lines args))

(defn extract-params
  [& args]
  (apply template/tags args))

(defn render-template
  [& args]
  (apply template/render args))

(defn obfuscate
  [s]
  (if (< (count s) 10)
    (apply clojure.core/str (take (count s) (repeat "*")))
    (clojure.core/str (subs s 0 5)
      (apply clojure.core/str (take (- (count s) 5) (repeat "*"))))))
