(ns com.vadelabs.utils-str.regexp
  "A regexp helpers and enhancements (mostly for cljs)."
  (:refer-clojure :exclude [regexp?])
  #?(:cljs (:require [goog.string :as gstr]))
  #?(:clj (:import (java.util.regex Pattern))))

(defn regexp?
  "Return `true` if `x` is a regexp pattern
  instance."
  [x]
  #?(:cljs (cljs.core/regexp? x)
     :clj (instance? Pattern x)))

(defn escape
  "Escapes characters in the string that are not safe
   to use in a RegExp."
  [s]
  #?(:clj  (Pattern/quote ^String s)
     :cljs (gstr/regExpEscape s)))
