(ns com.vadelabs.turbo-ui.sheet.interface
  (:require
   ["@radix-ui/react-dialog" :refer [Root Trigger Portal Overlay Content Close]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-icons.interface :as ti]))

(defui close "close"
  [{:keys [class] :as props}]
  (let [class [(sx
                 :absolute :right-4 :top-4
                 :rounded-sm :opacity-70 :ring-offset-background
                 :transition-opacity
                 [:hover :opacity-100]
                 [:focus :outline-none :ring-2 :ring-ring :ring-offset-2]
                 [:disabled :pointer-events-none]
                 ["[data-state\"open\"]" :bg-red-200])
               class]
        fprops (assoc props :class class)]
    ($ Close fprops
      ($ ti/render {:icon :close}))))

(defui container
  [props]
  ($ Root props))

(defui trigger
  [props]
  ($ Trigger props))

(defui portal
  [{:keys [children] :as props}]
  (let [sheet-class [(sx :fixed :inset-0 :z-50 :flex :justify-end)]]
    ($ Portal props
      ($ :div {:class sheet-class}
        children))))

(defui overlay
  [props]
  (let [class (sx :fixed :inset-0 :z-50
                :transition-all
                :duration-100
                ["[data-state=\"closed\"]" :animate-out]
                ["[data-state=\"closed\"]" :fade-out]
                ["[data-state=\"open\"]" :fade-in])
        fprops (assoc props :class class)]
    ($ Overlay fprops)))

(defui content
  [{:keys [position size class children] :as props}]
  (let [class [(sx
                 ;; common styles 
                 :fixed :z-50 :scale-100 :gap-4 :bg-white :p-5 :opacity-100 :shadow-lg :border 
                ;;  for right dir
                 #_:w-one-fourth [:w "500px"] :animate-in :slide-in-from-right [:h "calc(100vh - 60px)"] [:mt "60px"] :overflow-y-auto :duration-300)
               class]
        fprops (assoc props :class class :position position :size size)]
    ($ portal {:position position}
      ;; ($ overlay {})
      ($ Content fprops
        children
        ($ close {})))))
