(ns com.vadelabs.turbo-ui.scroll-area.interface
  (:require
   ["@radix-ui/react-scroll-area" :refer [Root Corner Viewport ScrollAreaScrollbar ScrollAreaThumb]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]))

(defui scrollbar "scrollbar"
  [{:keys [class orientation]
    :or {orientation "vertical"}
    :as props}]
  (let [class [(sx :flex :touch-none :select-none :transition-colors)
               (when (= orientation "vertical")
                 (sx :h-full :w-1.5 :border-l :border-l-transparent [:p "1px"]))
               (when (= orientation "horizontal")
                 (sx :h-1.5 :border-t :border-t-transparent [:p "1px"]))
               class]
        fprops (assoc props :class class :orientation orientation)]
    ($ ScrollAreaScrollbar fprops
      ($ ScrollAreaThumb {:class (sx :relative :flex-1 :rounded-full :bg-gray-600)}))))

(defui container "container"
  [{:keys [children class] :as props}]
  (let [class [(sx :relative :overflow-hidden)
               class]
        fprops (assoc props :class class)]
    ($ Root fprops
      ($ Viewport {:class (sx :h-full :w-full [:rounded "inherit"])}
        children)

      ($ scrollbar {})
      ($ Corner {}))))
