(ns com.vadelabs.turbo-css.tailwind.typography
  (:require
   [com.vadelabs.turbo-css.rule :refer [rule]]
   [com.vadelabs.turbo-css.tailwind.tokens :as tokens]
   [com.vadelabs.utils-core.interface :as uc]
   [com.vadelabs.utils-str.interface :as ustr]))

(def ^:private font-family
  "https://tailwindcss.com/docs/font-family"
  {:font-sans	{:font-family "ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, 'Noto Sans', sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol', 'Noto Color Emoji'"}
   :font-serif	{:font-family "ui-serif, Georgia, Cambria, 'Times New Roman', Times, serif"}
   :font-mono	{:font-family "ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, 'Liberation Mono', 'Courier New', monospace"}})

(def ^:private font-size
  "https://tailwindcss.com/docs/font-size"
  {:text-xs	{:font-size "0.75rem"
             :line-height "1rem"}
   :text-sm	{:font-size "0.875rem"
             :line-height "1.25rem"}
   :text-base	{:font-size "1rem"
               :line-height "1.5rem"}
   :text-lg	{:font-size "1.125rem"
             :line-height "1.75rem"}
   :text-xl	{:font-size "1.25rem"
             :line-height "1.75rem"}
   :text-2xl	{:font-size "1.5rem"
              :line-height "2rem"}
   :text-3xl	{:font-size "1.875rem"
              :line-height "2.25rem"}
   :text-4xl	{:font-size "2.25rem"
              :line-height "2.5rem"}
   :text-5xl	{:font-size "3rem"
              :line-height 1}
   :text-6xl	{:font-size "3.75rem"
              :line-height 1}
   :text-7xl	{:font-size "4.5rem"
              :line-height 1}
   :text-8xl	{:font-size "6rem"
              :line-height 1}
   :text-9xl	{:font-size "8rem"
              :line-height 1}})

(def ^:private font-smoothing
  {:antialiased	{:-webkit-font-smoothing "antialiased"
                 :-moz-osx-font-smoothing "grayscale"}
   :subpixel-antialiased	{:-webkit-font-smoothing "auto"
                          :-moz-osx-font-smoothing "auto"}})

(def ^:private font-style
  {:italic {:font-style "italic"}
   :non-italic {:font-style "normal"}})

(def ^:private font-weight
  "https://tailwindcss.com/docs/font-weight"
  {:font-thin	{:font-weight 100}
   :font-extralight	{:font-weight 200}
   :font-light	{:font-weight 300}
   :font-normal	{:font-weight 400}
   :font-medium	{:font-weight 500}
   :font-semibold	{:font-weight 600}
   :font-bold	{:font-weight 700}
   :font-extrabold	{:font-weight 800}
   :font-black	{:font-weight 900}})

(def ^:private font-variant-numeric
  {:normal-nums	{:font-variant-numeric "normal"}
   :ordinal	{:font-variant-numeric "ordinal"}
   :slashed-zero	{:font-variant-numeric "slashed-zero"}
   :lining-nums	{:font-variant-numeric "lining-nums"}
   :oldstyle-nums	{:font-variant-numeric "oldstyle-nums"}
   :proportional-nums	{:font-variant-numeric "proportional-nums"}
   :tabular-nums	{:font-variant-numeric "tabular-nums"}
   :diagonal-fractions	{:font-variant-numeric "diagonal-fractions"}
   :stacked-fractions	{:font-variant-numeric "stacked-fractions"}})

(def ^:private letter-spacing
  {:tracking-tighter	{:letter-spacing "-0.05em"}
   :tracking-tight	{:letter-spacing "-0.025em"}
   :tracking-normal	{:letter-spacing "0em"}
   :tracking-wide	{:letter-spacing "0.025em"}
   :tracking-wider	{:letter-spacing "0.05em"}
   :tracking-widest	{:letter-spacing "0.1em"}})

(def ^:private line-height
  {:leading-3	{:line-height ".75rem"}
   :leading-4	{:line-height "1rem"}
   :leading-5	{:line-height "1.25rem"}
   :leading-6	{:line-height "1.5rem"}
   :leading-7	{:line-height "1.75rem"}
   :leading-8	{:line-height "2rem"}
   :leading-9	{:line-height "2.25rem"}
   :leading-10	{:line-height "2.5rem"}
   :leading-none	{:line-height "1"}
   :leading-tight	{:line-height "1.25"}
   :leading-snug	{:line-height "1.375"}
   :leading-normal	{:line-height "1.5"}
   :leading-relaxed	{:line-height "1.625"}
   :leading-loose	{:line-height "2"}})

(def ^:private list-style-type
  {:list-none	{:list-style-type "none"}
   :list-disc	{:list-style-type "disc"}
   :list-decimal	{:list-style-type "decimal"}})

(def ^:private list-style-position
  {:list-inside	{:list-style-position "inside"}
   :list-outside	{:list-style-position "outside"}})

(def ^:private text-align
  {:text-left	{:text-align "left"}
   :text-center	{:text-align "center"}
   :text-right	{:text-align "right"}
   :text-justify	{:text-align "justify"}
   :text-start	{:text-align "start"}
   :text-end	{:text-align "end"}})

(def ^:private text-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (keyword (str "text-" (name k)))
        {:color v}))
    {}
    tokens/color-tokens))

(defmethod rule :color
  ([_ x] [[:& {:color x}]]))

(def ^:private text-decoration
  {:underline	{:text-decoration-line "underline"}
   :overline	{:text-decoration-line "overline"}
   :line-through	{:text-decoration-line "line-through"}
   :no-underline	{:text-decoration-line "none"}})

(def ^:private text-decoration-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (keyword (str "decoration-" (name k)))
        {:text-decoration-color v}))
    {}
    tokens/color-tokens))

(def ^:private text-decoration-style
  {:decoration-solid	{:text-decoration-style "solid"}
   :decoration-double	{:text-decoration-style "double"}
   :decoration-dotted	{:text-decoration-style "dotted"}
   :decoration-dashed	{:text-decoration-style "dashed"}
   :decoration-wavy	{:text-decoration-style "wavy"}})

(def ^:private text-decoration-thickness
  {:decoration-auto	{:text-decoration-thickness "auto"}
   :decoration-from-font	{:text-decoration-thickness "from-font"}
   :decoration-0	{:text-decoration-thickness "0px"}
   :decoration-1	{:text-decoration-thickness "1px"}
   :decoration-2	{:text-decoration-thickness "2px"}
   :decoration-4	{:text-decoration-thickness "4px"}
   :decoration-8	{:text-decoration-thickness "8px"}})

(def ^:private text-underline-offset
  {:underline-offset-auto	{:text-underline-offset "auto"}
   :underline-offset-0	{:text-underline-offset "0px"}
   :underline-offset-1	{:text-underline-offset "1px"}
   :underline-offset-2	{:text-underline-offset "2px"}
   :underline-offset-4	{:text-underline-offset "4px"}
   :underline-offset-8	{:text-underline-offset "8px"}})

(def ^:private text-transform
  {:uppercase	{:text-transform "uppercase"}
   :lowercase	{:text-transform "lowercase"}
   :capitalize	{:text-transform "capitalize"}
   :normal-case	{:text-transform "none"}})

(def ^:private text-overflow
  {:truncate	{:overflow "hidden"
              :text-overflow "ellipsis"
              :white-space "nowrap"}
   :text-ellipsis	{:text-overflow "ellipsis"}
   :text-clip	{:text-overflow "clip"}})

(def ^:private text-indent
  {:indent-0	{:text-indent "0px"}
   :indent-px	{:text-indent "1px"}
   :indent-0.5	{:text-indent "0.125rem"}
   :indent-1	{:text-indent "0.25rem"}
   :indent-1.5	{:text-indent "0.375rem"}
   :indent-2	{:text-indent "0.5rem"}
   :indent-2.5	{:text-indent "0.625rem"}
   :indent-3	{:text-indent "0.75rem"}
   :indent-3.5	{:text-indent "0.875rem"}
   :indent-4	{:text-indent "1rem"}
   :indent-5	{:text-indent "1.25rem"}
   :indent-6	{:text-indent "1.5rem"}
   :indent-7	{:text-indent "1.75rem"}
   :indent-8	{:text-indent "2rem"}
   :indent-9	{:text-indent "2.25rem"}
   :indent-10	{:text-indent "2.5rem"}
   :indent-11	{:text-indent "2.75rem"}
   :indent-12	{:text-indent "3rem"}
   :indent-14	{:text-indent "3.5rem"}
   :indent-16	{:text-indent "4rem"}
   :indent-20	{:text-indent "5rem"}
   :indent-24	{:text-indent "6rem"}
   :indent-28	{:text-indent "7rem"}
   :indent-32	{:text-indent "8rem"}
   :indent-36	{:text-indent "9rem"}
   :indent-40	{:text-indent "10rem"}
   :indent-44	{:text-indent "11rem"}
   :indent-48	{:text-indent "12rem"}
   :indent-52	{:text-indent "13rem"}
   :indent-56	{:text-indent "14rem"}
   :indent-60	{:text-indent "15rem"}
   :indent-64	{:text-indent "16rem"}
   :indent-72	{:text-indent "18rem"}
   :indent-80	{:text-indent "20rem"}
   :indent-96	{:text-indent "24rem"}})

(def ^:private vertical-align
  {:align-baseline	{:vertical-align "baseline"}
   :align-top	{:vertical-align "top"}
   :align-middle	{:vertical-align "middle"}
   :align-bottom	{:vertical-align "bottom"}
   :align-text-top	{:vertical-align "text-top"}
   :align-text-bottom	{:vertical-align "text-bottom"}
   :align-sub	{:vertical-align "sub"}
   :align-super	{:vertical-align "super"}})

(def ^:private whitespace
  {:whitespace-normal	{:white-space "normal"}
   :whitespace-nowrap	{:white-space "nowrap"}
   :whitespace-pre	{:white-space "pre"}
   :whitespace-pre-line	{:white-space "pre-line"}
   :whitespace-pre-wrap	{:white-space "pre-wrap"}})

(def ^:private word-break
  {:break-normal	{:overflow-wrap "normal"
                  :word-break "normal"}
   :break-words	{:overflow-wrap "break-word"}
   :break-all	{:word-break "break-all"}})

(def ^:private content
  {:content-none {:content "none"}})

(def static-rules
  (merge
    font-family
    font-size
    font-smoothing
    font-style
    font-weight
    font-variant-numeric
    letter-spacing
    line-height
    list-style-type
    text-align
    text-color
    text-decoration
    text-decoration-color
    text-decoration-style
    text-decoration-thickness
    text-underline-offset
    text-transform
    text-overflow
    text-indent
    vertical-align
    whitespace
    word-break
    content))
