(ns com.vadelabs.turbo-css.interface
  (:require
   [com.vadelabs.turbo-css.main :as css]
   [com.vadelabs.turbo-css.pseudo :as pseudo]
   [com.vadelabs.turbo-css.rule :as rule]
   #?(:cljs [com.vadelabs.turbo-css.sheet :as sheet])
   [com.vadelabs.turbo-css.tailwind.accessibility :as accessibility]
   [com.vadelabs.turbo-css.tailwind.animation :as animation]
   [com.vadelabs.turbo-css.tailwind.background :as background]
   [com.vadelabs.turbo-css.tailwind.border :as border]
   [com.vadelabs.turbo-css.tailwind.effect :as effect]
   [com.vadelabs.turbo-css.tailwind.filter :as tw-filter]
   [com.vadelabs.turbo-css.tailwind.flex :as flex]
   [com.vadelabs.turbo-css.tailwind.grid :as grid]
   [com.vadelabs.turbo-css.tailwind.interactivity :as interactivity]
   [com.vadelabs.turbo-css.tailwind.layout :as layout]
   [com.vadelabs.turbo-css.tailwind.ring :as ring]
   [com.vadelabs.turbo-css.tailwind.scrollbar :as scrollbar]
   [com.vadelabs.turbo-css.tailwind.sizing :as sizing]
   [com.vadelabs.turbo-css.tailwind.spacing :as spacing]
   [com.vadelabs.turbo-css.tailwind.svg :as svg]
   [com.vadelabs.turbo-css.tailwind.tables :as tables]
   [com.vadelabs.turbo-css.tailwind.transform :as tw-transform]
   [com.vadelabs.turbo-css.tailwind.transition :as transition]
   [com.vadelabs.turbo-css.tailwind.typography :as typography]
   #?(:clj [clojure.java.io :as io]))
  #?(:cljs (:require-macros [com.vadelabs.turbo-css.interface])))

(defn classname
  [rules]
  (css/c-fn nil rules))

(defn reset
  "Reset all styles"
  []
  (reset! css/styles {})
  (reset! css/theme-styles {})
  (reset! css/custom-selector-styles {})
  (reset! css/media-styles {}))

(def get-styles
  css/get-styles)

#?(:clj
   (defn build
     [output-file]
     (future
       (let [f (io/file output-file)]
         (println "Building CSS" output-file)
         (io/make-parents f)
         (spit f (css/compile-styles
                   @css/styles
                   @css/media-styles
                   @css/theme-styles
                   @css/custom-selector-styles))))))

#?(:clj
   (defn reload
     {:shadow.build/stage :flush}
     [build-state output-file]
     (build output-file)
     build-state))

(defn inject-css
  [cls static vars]
  #?(:cljs (sheet/css cls static vars)))

(defn defrules
  ([rules]
   (rule/defrules rules))
  ([rules pseudo-element-key]
   (rule/defrules rules pseudo-element-key)))

(def static-rules
  (merge
    accessibility/static-rules
    animation/static-rules
    background/static-rules
    border/static-rules
    effect/static-rules
    tw-filter/static-rules
    flex/static-rules
    grid/static-rules
    interactivity/static-rules
    layout/static-rules
    ring/static-rules
    sizing/static-rules
    spacing/static-rules
    svg/static-rules
    tables/static-rules
    tw-transform/static-rules
    transition/static-rules
    typography/static-rules))

(defrules static-rules)

(defn defmediarules
  [media]
  (css/defmediarules media))

(defn set-own-mediarules!
  [rules]
  (css/set-own-mediarules! rules))

(def pseudo-classes
  pseudo/classes)
(def pseudo-elements
  pseudo/elements)

(defmacro c
  [& rules]
  (css/c-fn &env rules))

(defmacro sx
  [& rules]
  #_(css/c-fn &env rules)
  (css/c-fn nil rules))

(defmacro c-eco
  "Uses only hashed version of classname. Is recomended for release purposes, because it minimizes resulting CSS file."
  [& rules]
  (css/c-fn nil rules))

(comment
  (reset)
  @css/styles
  (sx :ring)
  (sx :scrollbar)
  ;;
  )
