(ns com.vadelabs.turbo-ui.hover-card.interface
  (:require
   ["@radix-ui/react-hover-card" :refer [Root Trigger Content]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]))

(defui container "container"
  [{:keys [children] :as props}]
  ($ Root props children))

(defui trigger "trigger"
  [{:keys [children] :as props}]
  ($ Trigger props children))

(defui content "content"
  [{:keys [class side-offset]
    :or {side-offset 10}
    :as props}]
  (let [class [(sx :z-50 :rounded-md :border :shadow-md :outline-none :animate-in :zoom-in-90 :bg-gray-50)
               class]
        fprops (assoc props
                 :class class
                 :sideOffset side-offset)]
    ($ Content fprops)))
