(ns com.vadelabs.turbo-icons.interface
  (:require
   ["lucide-react" :as lr]
   ["react-icons/ai" :as ai]
   ["react-icons/bi" :as bi]
   ["react-icons/bs" :as bs]
   ["react-icons/fi" :as fi]
   ["react-icons/io" :as io]
   ["react-icons/md" :as md]
   ["react-icons/si" :as si]
   ["react-icons/tb" :as tb]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]))

(defui loader
  [props]
  ($ lr/Loader2 props))

(defui mail
  [props]
  ($ lr/Mail props))

(defui x
  [props]
  ($ lr/X props))

(defui check
  [props]
  ($ lr/Check props))

(defui google
  [props]
  ($ fi/FcGoogle props))

(defui chevron-down
  [props]
  ($ lr/ChevronDown props))

(defui chevron-right
  [props]
  ($ lr/ChevronRight props))

(defui chevrons-updown
  [props]
  ($ lr/ChevronsUpDown props))

(defui search
  [props]
  ($ lr/Search props))

(defui circle
  [props]
  ($ lr/Circle props))

(defui calendar
  [props]
  ($ lr/Calendar props))

(defui calendar-days
  [props]
  ($ lr/CalendarDays props))

(defui user
  [props]
  ($ lr/User props))

(defui credit-card
  [props]
  ($ lr/CreditCard props))

(defui settings
  [props]
  ($ lr/Settings props))

(defui keyboard
  [props]
  ($ lr/Keyboard props))

(defui users
  [props]
  ($ lr/Users props))

(defui user-plus
  [props]
  ($ lr/UserPlus props))

(defui message-square
  [props]
  ($ lr/MessageSquare props))

(defui plus-circle
  [props]
  ($ lr/PlusCircle props))

(defui github
  [props]
  ($ lr/Github props))

(defui logout
  [props]
  ($ lr/LogOut props))
(defui cloud
  [props]
  ($ lr/Cloud props))
(defui life-buoy
  [props]
  ($ lr/LifeBuoy props))
(defui left-arrow
  [props]
  ($ io/IoIosArrowBack props))
(defui right-arrow
  [props]
  ($ io/IoIosArrowForward props))

(defui render
  [{:keys [class width height size icon] :as props}]
  (let [fprops (dissoc props :icon)]
    (case icon
      :exit ($ bi/BiExit fprops)
      :copy-alt ($ bi/BiCopyAlt fprops)
      :logout ($ md/MdLogout fprops)
      :close ($ md/MdClose fprops)
      :dots-vertical ($ :span fprops ($ bi/BiDotsVerticalRounded {}))
      :outline-unarchive ($ :span fprops ($ md/MdOutlineUnarchive {}))
      :outline-star ($ :span fprops ($ ai/AiOutlineStar {}))
      :fill-star ($ :span fprops ($ ai/AiFillStar {}))
      :error ($ :span fprops ($ md/MdError {}))
      :broadcast ($ :span fprops
                   ($ bs/BsBroadcast {}))
      :thrash ($ :span fprops
                ($ tb/TbTrash {}))
      :minus ($ :span fprops
               ($ tb/TbMinus {}))
      :minimize ($ :span fprops
                  ($ tb/TbMinimize {}))
      :maximize ($ :span fprops
                  ($ tb/TbMaximize {}))
      :link ($ :span fprops
              ($ bi/BiLink {}))
      :unlink ($ :span fprops
                ($ bi/BiUnlink))
      :search ($ :span fprops
                ($ md/MdOutlineSearch {}))
      :google-maps ($ :span fprops
                     ($ si/SiGooglemaps {}))
      :cloud ($ :span fprops
               ($ lr/Cloud {}))
      :outline-dashboard ($ md/MdOutlineSpaceDashboard fprops)
      :solid-dashboard ($ md/MdSpaceDashboard fprops)
      ($ :svg {:class class
               :width (or width size "1em")
               :height (or height  size "1em")
               :fill "currentColor"}
        ($ :use {:href (str "/sprites/icons.svg#" (name icon))})))))
