(ns com.vadelabs.turbo-css.tailwind.scrollbar
  (:require
   [com.vadelabs.turbo-css.rule :refer [rule]]
   [com.vadelabs.turbo-css.tailwind.spacing :as spacing]
   [com.vadelabs.turbo-css.tailwind.tokens :as tokens]
   [com.vadelabs.turbo-css.utils :as utils]
   [com.vadelabs.utils-core.interface :as uc]
   [garden.compiler :refer [render-css]]))

(defmethod rule :scrollbar
  ([_] (rule :scrollbar "thin"))
  ([_ x] [[:& {:scrollbar-width x}]]))

(def ^:private color
  {:scrollbar-color {:scrollbar-color "red"}})

(def ^:private width
  {:scrollbar-thin {:scrollbar-width "thin"}
   :scrollbar-auto {:scrollbar-width "auto"}
   :scrollbar-none {:scrollbar-width "none"}})

(def ^:private gutter
  {:scrollbar-gutter-auto {:scrollbar-gutter "auto"}
   :scrollbar-gutter-stable {:scrollbar-gutter "stable"}})

(def static-rules
  (uc/deep-merge
    color
    width
    gutter))