(ns com.vadelabs.turbo-ui.dropdown.interface
  (:require
   ["@radix-ui/react-dropdown-menu" :refer [Root Trigger Portal
                                            Group Sub RadioGroup
                                            SubTrigger SubContent
                                            Content Item CheckboxItem
                                            ItemIndicator RadioItem
                                            Label Separator]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-ui.dialog.styles :as s]
   [com.vadelabs.turbo-icons.interface :as ti]
   [com.vadelabs.turbo-ui.separator.interface :as separator]))

(defui component
  [props]
  ($ Root props))

(defui trigger
  [props]
  ($ Trigger props))

(defui group
  [props]
  ($ Group props))

(defui portal
  [props]
  ($ Portal props))

(defui sub
  [props]
  ($ Sub props))

(defui radio-group
  [props]
  ($ RadioGroup props))

(defui sub-trigger
  [{:keys [children inset] :as props}]
  (let [class [(sx :flex :cursor-default :select-none :items-center :rounded-sm :py-1.5 :px-2
                 :text-sm :font-medium :outline-none
                 [:focus :bg-slate-100]
                 ["[data-state=\"open\"]" :bg-slate-100]
                 [:dark [:focus [:bg-slate-700]]
                  ["[data-state=\"open\"]" :bg-slate-700]])
               (when inset (sx :pl-8))]
        rprops (dissoc props :inset :children)
        fprops (assoc rprops :class class)]
    ($ SubTrigger fprops
      children
      ($ ti/chevron-right {:class (sx :ml-auto :h-4 :w-4)}))))

(defui sub-content
  [props]
  (let [class (sx :z-50 [:min-w "8rem"]
                :overflow-hidden :rounded-md
                :border :border-slate-100
                :bg-white :p-1 :text-slate-700
                :shadow-md
                :animate-in :slide-in-from-left-1
                [:dark :border-slate-800 :bg-slate-800 :text-slate-400])
        fprops (assoc props :class class)]
    ($ SubContent fprops)))

(defui content
  [{:keys [side-offset] :as props
    :or {side-offset 4}}]
  (let [class (sx :z-50 [:min-w "8rem"] :overflow-hidden
                :rounded-md :border :border-slate-100 :bg-white
                :p-1 :text-slate-700 :shadow-md
                :animate-in
                ["data-side=right" :slide-in-from-left-2]
                ["data-side=left" :slide-in-from-right-2]
                ["data-side=bottom" :slide-in-from-top-2]
                ["data-side=top" :slide-in-from-bottom-2]
                [:dark :border-slate-800 :bg-slate-800 :text-slate-400])
        rprops (dissoc props :side-offset)
        fprops (assoc rprops :class class :sideOffset side-offset)]
    ($ Portal {}
      ($ Content fprops))))

(defui item
  [{:keys [inset] :as props}]
  (let [class [(sx :relative :flex :cursor-default
                 :select-none :items-center :rounded-sm
                 :py-1.5 :px-2 :text-sm :font-medium :outline-none
                 [:focus :bg-slate-100]
                 ["[data-disabled]" :pointer-events-none :opacity-50]
                 [:dark [:focus :bg-slate-700]])
               (when inset (sx :pl-8))]
        rprops (dissoc props :inset)
        fprops (assoc rprops :class class)]
    ($ Item fprops)))

(defui checkbox-item
  [{:keys [children] :as props}]
  (let [class (sx :relative :flex :cursor-default :select-none
                :items-center :rounded-sm :py-1.5 :pl-8 :pr-2
                :text-sm :font-medium :outline-none
                [:focus :bg-slate-100]
                ["[data-disabled]" :pointer-events-none :opacity-50]
                [:dark [:focus :bg-slate-700]])
        rprops (dissoc props :children)
        fprops (assoc rprops :class class)]
    ($ CheckboxItem fprops
      ($ :span {:class (sx :absolute :left-2 :flex
                         :h-3.5 :w-3.5 :items-center :justify-center)}
        ($ ItemIndicator {}
          ($ ti/check {:class (sx :h-4 :w-4)})))
      children)))

(defui radio-item
  [{:keys [children] :as props}]
  (let [class (sx :relative :flex :cursor-default :select-none :items-center :rounded-sm :py-1.5 :pl-8 :pr-2 :text-sm :font-medium :outline-none
                [:focus :bg-slate-100]
                ["[data-disabled]" :pointer-events-none :opacity-50]
                [:dark [:focus :bg-slate-700]])
        rprops (dissoc props :children)
        fprops (assoc rprops :class class)]
    ($ RadioItem fprops
      ($ :span {:class (sx :absolute :left-2 :flex :h-3.5 :w-3.5
                         :items-center :justify-center)}
        ($ ItemIndicator {}
          ($ ti/circle {:class (sx :h-2 :w-2 :fill-current)})))
      children)))

(defui label
  [{:keys [inset] :as props}]
  (let [class [(sx :px-2 :py-1.5 :text-sm :font-semibold :text-slate-900
                 [:dark :text-slate-300])
               (when inset (sx :pl-8))]
        rprops (dissoc props :inset)
        fprops (assoc rprops :class class)]
    ($ Label fprops)))

(defui separator
  [props]
  (let [class (sx :-mx-1 :my-1 :h-px :bg-slate-100
                [:dark :bg-slate-700])
        fprops (assoc props :class class)]
    ($ Separator fprops)))

(defui shortcut
  [props]
  (let [class (sx :ml-auto :text-xs :tracking-widest :text-slate-500)
        fprops (assoc props :class class)]
    ($ :span fprops)))
