(ns com.vadelabs.turbo-ui.heading.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-ui.checkbox.styles :as s]))

(defui component
  [{:keys [as] :as props}]
  (let [class (s/classes props)
        removable-keys  (into (-> s/variants :variants keys) [:as])
        rprops (apply dissoc props removable-keys)
        fprops (cond-> rprops
                 class (assoc :class class))]
    (case as
      :h2 ($ :h2 fprops)
      :h3 ($ :h3 fprops)
      :h4 ($ :h4 fprops)
      :h5 ($ :h5 fprops)
      :h6 ($ :h6 fprops)
      ($ :h1 fprops))))
