(ns ^:no-doc com.vadelabs.turbo-ui.explorer.ui.sci.libs
  (:require ["react" :as react]
            ["react-dom" :as react-dom]
            ["react/jsx-runtime" :as jsx-runtime]
            ["vega" :as vega]
            ["vega-embed" :as vega-embed]
            ["vega-lite" :as vega-lite]
            cljs.reader
            goog.crypt.base64
            com.vadelabs.turbo-ui.explorer.colors
            com.vadelabs.turbo-ui.explorer.runtime.cson
            com.vadelabs.turbo-ui.explorer.ui.api
            com.vadelabs.turbo-ui.explorer.ui.app
            com.vadelabs.turbo-ui.explorer.ui.commands
            com.vadelabs.turbo-ui.explorer.ui.icons
            com.vadelabs.turbo-ui.explorer.ui.inspector
            com.vadelabs.turbo-ui.explorer.ui.rpc
            [com.vadelabs.turbo-ui.explorer.ui.sci.import :as sci-import]
            com.vadelabs.turbo-ui.explorer.ui.select
            com.vadelabs.turbo-ui.explorer.ui.state
            com.vadelabs.turbo-ui.explorer.ui.styled
            com.vadelabs.turbo-ui.explorer.ui.theme
            com.vadelabs.turbo-ui.explorer.ui.viewer.bin
            com.vadelabs.turbo-ui.explorer.ui.viewer.charts
            com.vadelabs.turbo-ui.explorer.ui.viewer.code
            com.vadelabs.turbo-ui.explorer.ui.viewer.csv
            com.vadelabs.turbo-ui.explorer.ui.viewer.date-time
            com.vadelabs.turbo-ui.explorer.ui.viewer.diff
            com.vadelabs.turbo-ui.explorer.ui.viewer.edn
            com.vadelabs.turbo-ui.explorer.ui.viewer.exception
            com.vadelabs.turbo-ui.explorer.ui.viewer.hiccup
            com.vadelabs.turbo-ui.explorer.ui.viewer.html
            com.vadelabs.turbo-ui.explorer.ui.viewer.image
            com.vadelabs.turbo-ui.explorer.ui.viewer.json
            com.vadelabs.turbo-ui.explorer.ui.viewer.log
            com.vadelabs.turbo-ui.explorer.ui.viewer.markdown
            com.vadelabs.turbo-ui.explorer.ui.viewer.relative-time
            com.vadelabs.turbo-ui.explorer.ui.viewer.table
            com.vadelabs.turbo-ui.explorer.ui.viewer.text
            com.vadelabs.turbo-ui.explorer.ui.viewer.transit
            com.vadelabs.turbo-ui.explorer.ui.viewer.tree
            com.vadelabs.turbo-ui.explorer.ui.viewer.vega
            com.vadelabs.turbo-ui.explorer.ui.viewer.vega-lite
            reagent.core
            reagent.dom
            [sci.core :as sci])
  (:import [goog.math Long]))

(def js-libs
  {"react"      react
   "react/jsx-runtime" jsx-runtime
   "react-dom"  react-dom
   "vega"       vega
   "vega-embed" vega-embed
   "vega-lite"  vega-lite})

(def namespaces
  (merge
    (sci-import/import-ns
      goog.crypt.base64
      goog.math
      com.vadelabs.turbo-ui.explorer.colors
      com.vadelabs.turbo-ui.explorer.runtime.cson
      com.vadelabs.turbo-ui.explorer.ui.api
      com.vadelabs.turbo-ui.explorer.ui.app
      com.vadelabs.turbo-ui.explorer.ui.commands
      com.vadelabs.turbo-ui.explorer.ui.icons
      com.vadelabs.turbo-ui.explorer.ui.inspector
      com.vadelabs.turbo-ui.explorer.ui.rpc
      com.vadelabs.turbo-ui.explorer.ui.select
      com.vadelabs.turbo-ui.explorer.ui.state
      com.vadelabs.turbo-ui.explorer.ui.styled
      com.vadelabs.turbo-ui.explorer.ui.theme
      com.vadelabs.turbo-ui.explorer.ui.viewer.bin
      com.vadelabs.turbo-ui.explorer.ui.viewer.charts
      com.vadelabs.turbo-ui.explorer.ui.viewer.code
      com.vadelabs.turbo-ui.explorer.ui.viewer.csv
      com.vadelabs.turbo-ui.explorer.ui.viewer.date-time
      com.vadelabs.turbo-ui.explorer.ui.viewer.diff
      com.vadelabs.turbo-ui.explorer.ui.viewer.edn
      com.vadelabs.turbo-ui.explorer.ui.viewer.exception
      com.vadelabs.turbo-ui.explorer.ui.viewer.hiccup
      com.vadelabs.turbo-ui.explorer.ui.viewer.html
      com.vadelabs.turbo-ui.explorer.ui.viewer.image
      com.vadelabs.turbo-ui.explorer.ui.viewer.json
      com.vadelabs.turbo-ui.explorer.ui.viewer.log
      com.vadelabs.turbo-ui.explorer.ui.viewer.markdown
      com.vadelabs.turbo-ui.explorer.ui.viewer.relative-time
      com.vadelabs.turbo-ui.explorer.ui.viewer.table
      com.vadelabs.turbo-ui.explorer.ui.viewer.text
      com.vadelabs.turbo-ui.explorer.ui.viewer.transit
      com.vadelabs.turbo-ui.explorer.ui.viewer.tree
      com.vadelabs.turbo-ui.explorer.ui.viewer.vega
      com.vadelabs.turbo-ui.explorer.ui.viewer.vega-lite
      reagent.core
      reagent.dom)
    (sci-import/import
      cljs.core/random-uuid
      cljs.core/tap>
      cljs.reader/read-string)))

(defn init [opts]
  (sci/init
    (merge {:namespaces namespaces
            :js-libs js-libs
            :classes {'js js/window
                      'Math js/Math
                      'goog.math.Long Long
                      :allow :all}
            :disable-arity-checks true}
      opts)))
