(ns com.vadelabs.turbo-ui.hover.interface
  (:require
   ["@radix-ui/react-hover-card" :refer [Root Trigger Content]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]))

(defui container
  [props]
  ($ Root props))

(defui trigger
  [props]
  ($ Trigger props))

(defui content
  [{:keys [class align side-offset] :as props
    :or {align "center"
         side-offset 4}}]
  (let [class [(sx :z-50 :w-64 :rounded-md :border :border-slate-100 :bg-white :p-4
                 :shadow-md :outline-none :animate-in :zoom-in-90
                 [:dark :border-slate-800 :bg-slate-800])
               class]
        fprops (-> props
                 (dissoc :align :side-offset)
                 (assoc :class class :align align :sideOffset side-offset))]
    ($ Content fprops)))
