(ns com.vadelabs.turbo-ui.explorer.ui.viewer.text
  (:require [clojure.string :as str]
            [com.vadelabs.turbo-ui.explorer.colors :as c]
            [com.vadelabs.turbo-ui.explorer.ui.inspector :as ins]
            [com.vadelabs.turbo-ui.explorer.ui.lazy :as l]
            [com.vadelabs.turbo-ui.explorer.ui.state :as state]
            [com.vadelabs.turbo-ui.explorer.ui.styled :as s]
            [com.vadelabs.turbo-ui.explorer.ui.theme :as theme]
            [reagent.core :as r]))

(defn inspect-text [value]
  (let [theme       (theme/use-theme)
        state       (state/use-state)
        context     (ins/use-context)
        location    (state/get-location context)
        opts        (ins/use-options)
        background  (ins/get-background)
        search-text @(r/cursor state [:search-text location])]
    [s/div
     {:style
      {:overflow :auto
       :background background
       :padding (:padding theme)
       :box-sizing :border-box
       :cursor :text
       :border-radius (:border-radius theme)
       :border [1 :solid (::c/border theme)]
       :max-height (when-not (:expanded? opts) "24rem")}}
     [s/table
      [s/tbody
       [l/lazy-seq
        (->>
          (str/split value #"\n")
          (map-indexed
            (fn [line line-content]
              [(inc line) line-content]))
          (filter
            (fn [[_ line-content]]
              (if search-text
                (some
                  #(str/includes? line-content %)
                  (str/split search-text #"\s+"))
                true)))
          (map
            (fn [[line line-content]]
              [s/tr
               {:key line}
               [s/td
                {:style
                 {:color (::c/number theme)
                  :background background
                  :font-size (:font-size theme)
                  :user-select :none
                  :text-align :right
                  :vertical-align :top
                  :padding-right (* 2 (:padding theme))}}
                [s/span line]]
               [s/td
                {:style
                 {:color (::c/text theme)
                  :background background
                  :text-align :left
                  :font-size (:font-size theme)}}
                [:pre {:style {:margin 0 :white-space :pre-wrap}}
                 [ins/highlight-words line-content]]]])))
        {:default-take 100 :step 100}]]]]))

(def viewer
  {:predicate string?
   :component inspect-text
   :name :com.vadelabs.turbo-ui.explorer.viewer/text
   :doc "View string as a text file."})
