(ns com.vadelabs.turbo-ui.explorer.shadow.remote
  (:require [com.vadelabs.turbo-ui.explorer.client.web :as client]))

(goog-define port 0)

(defn get-port
  "Get portal server port."
  {:added "0.28.0"}
  []
  (if-not (zero? port)
    port
    (let [error (js/Error.
                  (str "Portal server port is missing. "
                    "Did you add the com.vadelabs.turbo-ui.explorer.shadow.remote/hook to :build-hooks in shadow-cljs.edn? \n"
                    "See https://shadow-cljs.github.io/docs/UsersGuide.html#build-hooks for more info."))]
      (.error js/console error)
      (throw error))))

(defn submit
  "Tap target function.

  Usage:
    (add-tap com.vadelabs.turbo-ui.explorer.shadow/submit)
    (remove-tap com.vadelabs.turbo-ui.explorer.shadow/submit)"
  {:added "0.28.0"
   :see-also ["com.vadelabs.turbo-ui.explorer.api/submit"
              "com.vadelabs.turbo-ui.explorer.client.web/submit"]}
  ([value]
   (submit {:encoding :edn} value))
  ([option value]
   (client/submit (assoc option :port (get-port)) value)))
