(ns com.vadelabs.turbo-ui.separator.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-ui.separator.styles :as s]))

(defui component
  "orientation: Either vertical or horizontal. Defaults to horizontal.

   decorative: Whether or not the component is purely decorative. When true, accessibility-related attributes
   are updated so that that the rendered element is removed from the accessibility tree"
  [{:keys [label orientation decorative] :as props}]
  (let [class (s/classes props)
        removable-keys (into (-> s/variants :variants keys) [:label])
        rprops (apply dissoc props removable-keys)
        aria-orientation (when (= orientation :vertical)
                           orientation)
        fprops (cond-> rprops
                 label (assoc :data-content label)
                 orientation (assoc :data-orientation orientation)
                 decorative (assoc :role "none")
                 aria-orientation (assoc :aria-orientation aria-orientation)
                 (not decorative) (assoc :role "separator")
                 class (assoc :class class))]
    ($ :div fprops)))
