(ns com.vadelabs.turbo-ui.input.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :p-3 :border-2 :rounded-lg :bg-transparent
           [:focus
            :outline-none])
   :defaults {:color :gray}
   :variants {:color
              {:gray (sx :border-gray-300
                       [:focus :border-gray-500])
               :brand
               (sx :border-brand-300
                 [:focus :border-brand-500])}}})

(defn classes
  ([props]
   ((uc/cva variants) props))
  ([class props]
   ((uc/cva {:base class}) props)))
