(ns com.vadelabs.turbo-ui.flex.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :flex :border-box)
   :defaults {:direction :row
              :align :stretch
              :justify :start
              :wrap :no-wrap}
   :variants {:direction {:row (sx :flex-row)
                          :column (sx :flex-col)
                          :row-reverse (sx :flex-row-reverse)
                          :column-reverse (sx :flex-col-reverse)}
              :align
              {:start (sx :items-start)
               :center (sx :items-center)
               :end (sx :items-end)
               :stretch (sx :items-stretch)
               :baseline (sx :items-baseline)}
              :justify
              {:start (sx :justify-start)
               :center (sx :justify-center)
               :end (sx :justify-end)
               :between (sx :justify-between)}
              :wrap
              {:no-wrap (sx :flex-nowrap)
               :wrap (sx :flex-wrap)
               :wrap-reverse (sx :flex-wrap-reverse)}
              :gap
              {1 (sx :gap-1)
               2 (sx :gap-2)
               3 (sx :gap-3)
               4 (sx :gap-4)
               5 (sx :gap-5)
               6 (sx :gap-6)
               7 (sx :gap-7)
               8 (sx :gap-8)}}})

(def classes
  (uc/cva variants))

#_(classes {:direction :column})
