(ns com.vadelabs.turbo-ui.explorer.ui.viewer.json
  (:require [com.vadelabs.turbo-ui.explorer.ui.inspector :as ins]))

(defn- parse-json [json-string]
  (try (js->clj (js/JSON.parse json-string) :keywordize-keys true)
    (catch :default e (ins/error->data e))))

(defn json? [value] (string? value))

(defn inspect-json [json-string]
  [ins/tabs
   {:com.vadelabs.turbo-ui.explorer.viewer/json (parse-json json-string)
    "..."               json-string}])

(def viewer
  {:predicate json?
   :component inspect-json
   :name :com.vadelabs.turbo-ui.explorer.viewer/json
   :doc "Parse a string as JSON. Will render error if parsing fails."})
