(ns com.vadelabs.turbo-ui.avatar.interface
  (:require
   ["@radix-ui/react-avatar" :refer [Root Image Fallback]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]))

#_(defui container
    [props]
    (let [class (sx :relative :flex :h-10 :w-10 :shrink-0 :overflow-hidden :rounded-full)
          fprops (cond-> props
                   class (assoc :class class))]
      ($ Root fprops)))

(defui group
  [{:keys [children]}]
  ($ :span {:class (sx :ml-3 :inline-flex
                     [" > [avatar-container]" :-ml-2.5])}
    children))

(defui container
  [{:keys [class size] :as props
    :or {class []
         size :sm}}]
  (let [class (if (string? class) [class] class)
        class (cond-> (into class [(sx :inline-block :shrink-0
                                     :relative :overflow-hidden :rounded-full)])
                (= size :sm) (conj (sx :h-6 :w-6 :text-xs))
                (= size :md) (conj (sx :h-8 :w-8 :text-sm))
                (= size :lg) (conj (sx :h-10 :w-10)))
        fprops (cond-> props
                 class (assoc :class class
                         "avatar-container" " "))]
    ($ Root fprops)))

(defui image
  [props]
  (let [class (sx :aspect-square :h-full :w-full)
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Image fprops)))

(defui fallback
  [{:keys [class] :as props}]
  (let [class [(sx :flex :h-full :w-full :items-center :justify-center :rounded-full :bg-black :text-white)
               class]
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Fallback fprops)))
