(ns com.vadelabs.turbo-css.tailwind.interactivity
  (:require
   [com.vadelabs.turbo-css.tailwind.tokens :as tokens]
   [com.vadelabs.turbo-css.utils :as utils]))

(def ^:private accent-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (keyword (str "accent-" (name k)))
        {:accent-color v}))
    {}
    tokens/color-tokens))

(def ^:private appearance
  {:appearance-none	 {:appearance "none"}})

(def ^:private cursor
  {:cursor-auto	{:cursor "auto"}

   :cursor-default	{:cursor "default"}

   :cursor-pointer	{:cursor "pointer"}

   :cursor-wait	{:cursor "wait"}

   :cursor-text	{:cursor "text"}

   :cursor-move	{:cursor "move"}

   :cursor-help	{:cursor "help"}

   :cursor-not-allowed	{:cursor "not-allowed"}

   :cursor-none	{:cursor "none"}
   :cursor-context-menu	{:cursor "context-menu"}

   :cursor-progress	{:cursor "progress"}

   :cursor-cell	{:cursor "cell"}

   :cursor-crosshair	{:cursor "crosshair"}

   :cursor-vertical-text	{:cursor "vertical-text"}

   :cursor-alias	{:cursor "alias"}

   :cursor-copy	{:cursor "copy"}

   :cursor-no-drop	{:cursor "no-drop"}

   :cursor-grab	{:cursor "grab"}

   :cursor-grabbing	{:cursor "grabbing"}

   :cursor-all-scroll	{:cursor "all-scroll"}

   :cursor-col-resize	{:cursor "col-resize"}

   :cursor-row-resize	{:cursor "row-resize"}

   :cursor-n-resize	{:cursor "n-resize"}

   :cursor-e-resize	{:cursor "e-resize"}

   :cursor-s-resize	{:cursor "s-resize"}

   :cursor-w-resize	{:cursor "w-resize"}

   :cursor-ne-resize	{:cursor "ne-resize"}

   :cursor-nw-resize	{:cursor "nw-resize"}

   :cursor-se-resize	{:cursor "se-resize"}

   :cursor-sw-resize	{:cursor "sw-resize"}

   :cursor-ew-resize	{:cursor "ew-resize"}

   :cursor-ns-resize	{:cursor "ns-resize"}

   :cursor-nesw-resize	{:cursor "nesw-resize"}

   :cursor-nwse-resize	{:cursor "nwse-resize"}

   :cursor-zoom-in	{:cursor "zoom-in"}

   :cursor-zoom-out	{:cursor "zoom-out"}})

(def ^:private caret-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (keyword (str "caret-" (name k)))
        {:accent-color v}))
    {}
    tokens/color-tokens))

(def ^:private pointer-events
  {:pointer-events-none	{:pointer-events "none"}
   :pointer-events-auto	{:pointer-events "auto"}})

(def ^:private resize
  {:resize-none	{:resize "none"}
   :resize-y	{:resize "vertical"}
   :resize-x	{:resize "horizontal"}
   :resize	{:resize "both"}})

(def scroll-behavior
  {:scroll-auto	{:scroll-behavior "auto"}
   :scroll-smooth	{:scroll-behavior "smooth"}})

(def ^:private space-tokens
  {"0" "0px"
   "px" "1px"
   "0.5"  "0.125rem"
   "1" "0.25rem"
   "1.5" "0.375rem"
   "2" "0.5rem"
   "2.5" "0.625rem"
   "3" "0.75rem"
   "3.5" "0.875rem"
   "4" "1rem"
   "5" "1.25rem"
   "6" "1.5rem"
   "7" "1.75rem"
   "8" "2rem"
   "9" "2.25rem"
   "10" "2.5rem"
   "11" "2.75rem"
   "12" "3rem"
   "14" "3.5rem"
   "16" "4rem"
   "20" "5rem"
   "24" "6rem"
   "28" "7rem"
   "32" "8rem"
   "36" "9rem"
   "40" "10rem"
   "44" "11rem"
   "48" "12rem"
   "52" "13rem"
   "56" "14rem"
   "60" "15rem"
   "64" "16rem"
   "72" "18rem"
   "80" "20rem"
   "96" "24rem"})

(def ^:private scroll-margin
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (keyword (str "scroll-m-" k)) {:scroll-margin (utils/as-unit v)}
        (keyword (str "scroll-mx-" k)) {:scroll-margin-right (utils/as-unit v) :scroll-margin-left (utils/as-unit v)}
        (keyword (str "scroll-my-" k)) {:scroll-margin-top (utils/as-unit v) :scroll-margin-bottom (utils/as-unit v)}
        (keyword (str "scroll-mt-" k)) {:scroll-margin-top (utils/as-unit v)}
        (keyword (str "scroll-mr-" k)) {:scroll-margin-right (utils/as-unit v)}
        (keyword (str "scroll-mb-" k)) {:scroll-margin-bottom (utils/as-unit v)}
        (keyword (str "scroll-ml-" k)) {:scroll-margin-left (utils/as-unit v)}))
    {}
    space-tokens))

(def ^:private scroll-padding
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (keyword (str "scroll-p-" k)) {:scroll-padding (utils/as-unit v)}
        (keyword (str "scroll-px-" k)) {:scroll-padding-right (utils/as-unit v) :scroll-padding-left (utils/as-unit v)}
        (keyword (str "scroll-py-" k)) {:scroll-padding-top (utils/as-unit v) :scroll-padding-bottom (utils/as-unit v)}
        (keyword (str "scroll-pt-" k)) {:scroll-padding-top (utils/as-unit v)}
        (keyword (str "scroll-pr-" k)) {:scroll-padding-right (utils/as-unit v)}
        (keyword (str "scroll-pb-" k)) {:scroll-padding-bottom (utils/as-unit v)}
        (keyword (str "scroll-pl-" k)) {:scroll-padding-left (utils/as-unit v)}))
    {}
    space-tokens))

(def ^:private scroll-snap-align
  {:snap-start	{:scroll-snap-align "start"}
   :snap-end	{:scroll-snap-align "end"}
   :snap-center	{:scroll-snap-align "center"}
   :snap-align-none	{:scroll-snap-align "none"}})

(def ^:private scroll-snap-stop
  {:snap-normal	{:scroll-snap-stop "normal"}
   :snap-always	{:scroll-snap-stop "always"}})

(def ^:private scroll-snap-type
  {:snap-none	{:scroll-snap-type "none"}
   :snap-x	{:scroll-snap-type "x var(--tw-scroll-snap-strictness)"}
   :snap-y	{:scroll-snap-type "y var(--tw-scroll-snap-strictness)"}
   :snap-both	{:scroll-snap-type "both var(--tw-scroll-snap-strictness)"}
   :snap-mandatory	{:--tw-scroll-snap-strictness "mandatory"}
   :snap-proximity	{:--tw-scroll-snap-strictness "proximity"}})

(def ^:private touch-action
  {:touch-auto	{:touch-action "auto"}
   :touch-none	{:touch-action "none"}
   :touch-pan-x	{:touch-action "pan-x"}
   :touch-pan-left	{:touch-action "pan-left"}
   :touch-pan-right	{:touch-action "pan-right"}
   :touch-pan-y	{:touch-action "pan-y"}
   :touch-pan-up	{:touch-action "pan-up"}
   :touch-pan-down	{:touch-action "pan-down"}
   :touch-pinch-zoom	{:touch-action "pinch-zoom"}
   :touch-manipulation	{:touch-action "manipulation"}})

(def ^:private user-select
  {:select-none	{:user-select "none"}
   :select-text	{:user-select "text"}
   :select-all	{:user-select "all"}
   :select-auto	{:user-select "auto"}})

(def ^:private will-change
  {:will-change-auto	{:will-change "auto"}
   :will-change-scroll	{:will-change "scroll-position"}
   :will-change-contents	{:will-change "contents"}
   :will-change-transform	{:will-change "transform"}})

(def static-rules
  (merge
    accent-color
    appearance
    cursor
    caret-color
    pointer-events
    resize
    scroll-behavior
    scroll-margin
    scroll-padding
    scroll-snap-align
    scroll-snap-stop
    scroll-snap-type
    touch-action
    user-select
    will-change))
