(ns com.vadelabs.turbo-ui.dialog.interface
  (:require
   ["@radix-ui/react-dialog" :refer [Root Trigger Portal Description
                                     Overlay Content Close Title]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-icons.interface :as ti]
   [com.vadelabs.turbo-ui.dialog.styles :as s]))

(defui container
  [props]
  ($ Root props))

(defui trigger
  [props]
  (let [class (s/trigger props)
        fprops (cond-> props
                 :true (dissoc :size :variant :class)
                 class (assoc :class class))]
    ($ Trigger props)))

(defui portal
  [{:keys [children] :as props}]
  (let [fprops (apply dissoc props [:children])]
    ($ Portal fprops
      ($ :div {:class (sx :fixed :inset-0 :z-50
                        :flex :items-start :justify-center
                        [:sm :items-center])}
        children))))

;; ;; fixed inset-0 z-50 bg-black/50 backdrop-blur-sm transition-all duration-100
;; ;; data-[state=closed]:animate-out data-[state=open]:fade-in data-[state=closed]:fade-out
(defui overlay
  [props]
  (let [class (sx :fixed :inset-0 :z-50
                :bg-black :opacity-50
                :backdrop-blur-sm :transition-all :duration-100
                :flex :items-center :justify-center
                ["[data-state=\"closed\"]" :animate-out :fade-out]
                ["[data-state=\"open\"]" :fade-in])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Overlay fprops)))

;; ;; "absolute top-4 right-4 rounded-sm opacity-70 transition-opacity hover:opacity-100 focus:outline-none focus:ring-2 focus:ring-slate-400 focus:ring-offset-2 disabled:pointer-events-none
;; ;; data-[state=open]:bg-slate-100 dark:focus:ring-slate-400 dark:focus:ring-offset-slate-900
;; ;;dark:data-[state=open]:bg-slate-800"
(defui close
  [props]
  ($ Close {:class (sx :absolute :top-4 :right-4
                     :rounded-sm :opacity-70
                     :transition-opacity
                     [:hover :opacity-100]
                     [:focus :outline-none :ring-2 :ring-slate-400 :ring-offset-2]
                     [:disabled :pointer-events-none]
                     ["[data-state=\"open\"]" :bg-slate-100]
                     [:dark
                      [:focus :ring-slate-400 :ring-offset-slate-900]
                      ["[data-state=\"open\"]" :bg-slate-800]])}
    (ti/x {:class (sx :h-4 :w-4)})
    ($ :span {:class (sx :sr-only)}
      "Close")))

(defui content
  [{:keys [children class] :as props}]

  (let [class [(sx
                 :fixed
                 :z-50
                 :grid  :gap-4
                ;;  :w-auto
                ;;  :max-w-auto
                 :rounded-lg :bg-white :p-6
                 :animate-in
                 #_["[data-state=\"open\"]"
                    :fade-in-90 :slide-in-from-bottom-10
                    [:sm :slide-in-from-bottom-0]]
                 [:dark :bg-slate-900])
               class]
        rprops (dissoc props :children)
        fprops (-> rprops
                 (assoc :class class))]
    ($ portal {}
      ($ overlay {})
      ($ Content fprops children ($ close {})))))

(defui header
  [props]
  (let [class (sx :flex :flex-col :space-y-2 :text-center
                [:sm :text-left])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ :div fprops)))

(defui footer
  [props]
  (let [class (sx :flex :flex-col-reverse
                [:sm :flex-row :justify-end :space-x-2])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ :div fprops)))

(defui title
  [props]
  (let [class (sx :text-lg :font-semibold :text-slate-900
                [:dark :text-slate-50])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Title fprops)))

(defui description
  [props]
  (let [class (sx :text-sm :text-slate-500
                [:dark :text-slate-400])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Description fprops)))
