(ns com.vadelabs.turbo-ui.input.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]))

(defui container
  [{:keys [class] :as props}]
  (let [class [(sx :flex :h-10 :w-full :rounded-md :border
                 :border-slate-300 :bg-transparent :py-2 :px-3
                 :text-sm
                 [:placeholder :text-slate-400]
                 [:focus :outline-none :ring-2 :ring-slate-400 :ring-offset-2]
                 [:disabled :cursor-not-allowed :disabled:opacity-50]
                 [:dark :border-slate-700 :dark :text-slate-50 :dark [:focus :ring-slate-400 :ring-offset-slate-900]])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ :input fprops)))
